/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.shadow;

import io.lumine.shadow.Shadow;
import io.lumine.shadow.TargetResolver;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

@java.lang.annotation.Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Target {
    public static final TargetResolver RESOLVER = new TargetResolver(){

        @Override
        public @NonNull Optional<Class<?>> lookupClass(@NonNull Class<? extends Shadow> shadowClass) throws ClassNotFoundException {
            Target annotation = shadowClass.getAnnotation(Target.class);
            if (annotation == null) {
                return Optional.empty();
            }
            return Optional.of(Class.forName(annotation.value()));
        }

        @Override
        public @NonNull Optional<String> lookupMethod(@NonNull Method shadowMethod, @NonNull Class<? extends Shadow> shadowClass, @NonNull Class<?> targetClass) {
            return Optional.ofNullable(shadowMethod.getAnnotation(Target.class)).map(Target::value);
        }

        @Override
        public @NonNull Optional<String> lookupField(@NonNull Method shadowMethod, @NonNull Class<? extends Shadow> shadowClass, @NonNull Class<?> targetClass) {
            return Optional.ofNullable(shadowMethod.getAnnotation(Target.class)).map(Target::value);
        }
    };

    public @NonNull String value();
}

