/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.paper.adapters.item;

import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.items.components.AbstractItemAttackRangeComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBlocksAttacksComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBreakSoundComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemBucketEntityDataComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemConsumableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemDeathProtectionComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemEnchantableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemFoodComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemGliderComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemJukeboxPlayableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemKineticWeaponComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemNoteBlockSoundComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemOminousBottleAmplifierComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemPiercingWeaponComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemPotDecorationsComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemPotionComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemRepairableComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemTooltipComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemUseRemainderComponent;
import io.lumine.mythic.api.adapters.items.components.AbstractItemWeaponComponent;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.bukkit.adapters.BukkitPotionEffect;
import io.lumine.mythic.bukkit.adapters.item.ItemComponentBukkitItemStack;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.paper.adapters.item.components.consumable.PaperItemConsumableComponent;
import io.lumine.mythic.paper.adapters.item.components.consumable.PaperItemDeathProtectionComponent;
import io.papermc.paper.block.BlockPredicate;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.AttackRange;
import io.papermc.paper.datacomponent.item.BlocksAttacks;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.DeathProtection;
import io.papermc.paper.datacomponent.item.Enchantable;
import io.papermc.paper.datacomponent.item.FoodProperties;
import io.papermc.paper.datacomponent.item.ItemAdventurePredicate;
import io.papermc.paper.datacomponent.item.JukeboxPlayable;
import io.papermc.paper.datacomponent.item.KineticWeapon;
import io.papermc.paper.datacomponent.item.OminousBottleAmplifier;
import io.papermc.paper.datacomponent.item.PiercingWeapon;
import io.papermc.paper.datacomponent.item.PotDecorations;
import io.papermc.paper.datacomponent.item.PotionContents;
import io.papermc.paper.datacomponent.item.Repairable;
import io.papermc.paper.datacomponent.item.UseRemainder;
import io.papermc.paper.datacomponent.item.Weapon;
import io.papermc.paper.datacomponent.item.blocksattacks.DamageReduction;
import io.papermc.paper.datacomponent.item.blocksattacks.ItemDamageFunction;
import io.papermc.paper.datacomponent.item.consumable.ItemUseAnimation;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import io.papermc.paper.registry.tag.TagKey;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.JukeboxSong;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.damage.DamageType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemComponentPaperItemStack
extends ItemComponentBukkitItemStack {
    public ItemComponentPaperItemStack(ItemStack itemStack) {
        super(itemStack);
    }

    @Override
    public BukkitItemStack clone() {
        return new ItemComponentPaperItemStack(this.itemStack.clone());
    }

    @Override
    public ItemComponentPaperItemStack editMeta(Consumer<ItemMeta> block) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta == null) {
            meta = Bukkit.getItemFactory().getItemMeta(this.itemStack.getType());
        }
        if (meta == null) {
            return this;
        }
        block.accept(meta);
        this.itemStack.setItemMeta(meta);
        return this;
    }

    @Override
    public int getDurability() {
        return Optional.ofNullable(this.getItemMeta()).map(meta -> {
            if (meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                return damageable.getDamage();
            }
            if (this.itemStack.hasData((DataComponentType)DataComponentTypes.DAMAGE)) {
                return (Integer)this.itemStack.getData(DataComponentTypes.DAMAGE);
            }
            return 0;
        }).orElse(0);
    }

    @Override
    public ItemComponentBukkitItemStack durability(int durability) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setDamage(durability);
            this.itemStack.setItemMeta(meta);
        } else {
            this.itemStack.setData(DataComponentTypes.DAMAGE, (Object)durability);
        }
        return this;
    }

    @Override
    public int getMaxDurability() {
        Damageable damageable;
        ItemMeta itemMeta;
        if (this.itemStack.hasItemMeta() && (itemMeta = this.itemStack.getItemMeta()) instanceof Damageable && (damageable = (Damageable)itemMeta).hasMaxDamage()) {
            return damageable.getMaxDamage();
        }
        if (this.itemStack.hasData((DataComponentType)DataComponentTypes.MAX_DAMAGE)) {
            return (Integer)this.itemStack.getData(DataComponentTypes.MAX_DAMAGE);
        }
        return this.itemStack.getType().getMaxDurability();
    }

    @Override
    public int getRepairCost() {
        if (this.itemStack.hasData((DataComponentType)DataComponentTypes.REPAIR_COST)) {
            return (Integer)this.itemStack.getData(DataComponentTypes.REPAIR_COST);
        }
        return super.getRepairCost();
    }

    @Override
    public ItemComponentBukkitItemStack maxDurability(int durability) {
        ItemMeta meta = this.itemStack.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setMaxDamage(Integer.valueOf(durability));
            this.itemStack.setItemMeta(meta);
        } else {
            this.itemStack.setData(DataComponentTypes.MAX_DAMAGE, (Object)durability);
        }
        return this;
    }

    @Override
    public ItemComponentPaperItemStack repairCost(int repairCost) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
            this.itemStack.setData(DataComponentTypes.REPAIR_COST, (Object)repairCost);
            return this;
        }
        super.repairCost(repairCost);
        return this;
    }

    @Override
    public ItemComponentPaperItemStack canPlaceOn(Collection<Material> materials) {
        Set blockTypes = materials.stream().map(mat -> mat.asBlockType()).collect(Collectors.toSet());
        RegistryKeySet registrySet = RegistrySet.keySetFromValues((RegistryKey)RegistryKey.BLOCK, blockTypes);
        ItemAdventurePredicate predicate = (ItemAdventurePredicate)ItemAdventurePredicate.itemAdventurePredicate().addPredicate(BlockPredicate.predicate().blocks(registrySet).build()).build();
        this.itemStack.setData(DataComponentTypes.CAN_PLACE_ON, (Object)predicate);
        return this;
    }

    @Override
    public ItemComponentPaperItemStack canBreak(Collection<Material> materials) {
        Set blockTypes = materials.stream().map(mat -> mat.asBlockType()).collect(Collectors.toSet());
        RegistryKeySet registrySet = RegistrySet.keySetFromValues((RegistryKey)RegistryKey.BLOCK, blockTypes);
        ItemAdventurePredicate predicate = (ItemAdventurePredicate)ItemAdventurePredicate.itemAdventurePredicate().addPredicate(BlockPredicate.predicate().blocks(registrySet).build()).build();
        this.itemStack.setData(DataComponentTypes.CAN_BREAK, (Object)predicate);
        return this;
    }

    @Override
    public ItemComponentPaperItemStack applyFoodComponent(AbstractItemFoodComponent foodData) {
        FoodProperties.Builder foodBuilder = this.itemStack.hasData((DataComponentType)DataComponentTypes.FOOD) ? (FoodProperties.Builder)((FoodProperties)this.itemStack.getData(DataComponentTypes.FOOD)).toBuilder() : FoodProperties.food();
        if (foodData.getCanAlwaysEat() != null) {
            foodBuilder.canAlwaysEat(foodData.getCanAlwaysEat().booleanValue());
        }
        if (foodData.getNutrition() != null) {
            foodBuilder.nutrition(foodData.getNutrition().intValue());
        }
        if (foodData.getSaturation() != null) {
            foodBuilder.saturation(foodData.getSaturation().floatValue());
        }
        this.itemStack.setData(DataComponentTypes.FOOD, (Object)((FoodProperties)foodBuilder.build()));
        return this;
    }

    @Override
    public ItemComponentPaperItemStack applyConsumableComponent(AbstractItemConsumableComponent component) {
        PaperItemConsumableComponent consumableData = (PaperItemConsumableComponent)component;
        Consumable.Builder consumableBuilder = this.itemStack.hasData((DataComponentType)DataComponentTypes.CONSUMABLE) ? (Consumable.Builder)((Consumable)this.itemStack.getData(DataComponentTypes.CONSUMABLE)).toBuilder() : Consumable.consumable();
        if (consumableData.getConsumeSeconds() != null) {
            consumableBuilder.consumeSeconds(consumableData.getConsumeSeconds().floatValue());
        }
        if (consumableData.getHasConsumeParticles() != null) {
            consumableBuilder.hasConsumeParticles(consumableData.getHasConsumeParticles().booleanValue());
        }
        if (consumableData.getAnimation() != null) {
            try {
                ItemUseAnimation animation = ItemUseAnimation.valueOf((String)consumableData.getAnimation());
                consumableBuilder.animation(animation);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (consumableData.getSound() != null) {
            consumableBuilder.sound(Key.key((String)consumableData.getSound()));
        }
        if (consumableData.getConsumeEffects() != null) {
            consumableBuilder.addEffects(consumableData.getConsumeEffects());
        }
        this.itemStack.setData(DataComponentTypes.CONSUMABLE, (Object)((Consumable)consumableBuilder.build()));
        return this;
    }

    @Override
    public ItemComponentPaperItemStack applyPotionComponent(DropMetadata dropMetadata, AbstractItemPotionComponent potionData) {
        PotionContents.Builder potionComponent = PotionContents.potionContents();
        if (potionData.getCustomName() != null) {
            potionComponent.customName(potionData.getCustomName().get(dropMetadata));
        }
        if (potionData.getPotionColor() != null) {
            potionComponent.customColor(potionData.getPotionColor().get(dropMetadata).toBukkitColor());
        }
        for (BukkitPotionEffect effect : potionData.getEffects()) {
            potionComponent.addCustomEffect(effect.getEffect());
        }
        this.itemStack.setData(DataComponentTypes.POTION_CONTENTS, (DataComponentBuilder)potionComponent);
        return this;
    }

    @Override
    public ItemComponentPaperItemStack copy() {
        return new ItemComponentPaperItemStack(this.itemStack.clone());
    }

    @Override
    public AbstractItemStack applyTooltipComponent(AbstractItemTooltipComponent abstractItemTooltipComponent) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_3)) {
            String tooltipStyle = abstractItemTooltipComponent.getTooltipStyle();
            if (tooltipStyle == null) {
                return this;
            }
            Key tooltipKey = !tooltipStyle.contains(":") ? (MythicBukkit.inst().getCompatibility().getCrucible().isPresent() && MythicBukkit.inst().getCompatibility().getCrucible().get().isGeneratedTooltip(tooltipStyle) ? Key.key((String)"mythic", (String)tooltipStyle) : Key.key((String)"minecraft", (String)tooltipStyle)) : Key.key((String)tooltipStyle);
            this.itemStack.setData(DataComponentTypes.TOOLTIP_STYLE, (Object)tooltipKey);
        }
        return this;
    }

    @Override
    public AbstractItemStack applyBlocksAttacksComponent(DropMetadata dropMetadata, AbstractItemBlocksAttacksComponent componentConfig) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_8)) {
            BlocksAttacks.Builder componentBuilder = BlocksAttacks.blocksAttacks();
            if (componentConfig.getBlockDelaySeconds() != null) {
                componentBuilder.blockDelaySeconds(componentConfig.getBlockDelaySeconds().floatValue());
            }
            if (componentConfig.getDisableCooldownScale() != null) {
                componentBuilder.disableCooldownScale(componentConfig.getDisableCooldownScale().floatValue());
            }
            if (componentConfig.getDamageReductions() != null && !componentConfig.getDamageReductions().isEmpty()) {
                for (AbstractItemBlocksAttacksComponent.DamageReduction reduction : componentConfig.getDamageReductions()) {
                    DamageReduction.Builder reductionBuilder = DamageReduction.damageReduction();
                    AbstractItemBlocksAttacksComponent.DamageTypeSelector selector = reduction.getType();
                    RegistryKeySet typeSet = null;
                    if (selector == null || selector.isAll()) {
                        typeSet = RegistrySet.keySetFromValues((RegistryKey)RegistryKey.DAMAGE_TYPE, (Iterable)Registry.DAMAGE_TYPE);
                    } else if (selector.getSingle() != null) {
                        NamespacedKey key;
                        DamageType damageType;
                        Object typeKey = selector.getSingle().toLowerCase(Locale.ROOT);
                        if (!((String)typeKey).contains(":")) {
                            typeKey = "minecraft:" + (String)typeKey;
                        }
                        DamageType damageType2 = damageType = (key = NamespacedKey.fromString((String)typeKey)) != null ? (DamageType)Registry.DAMAGE_TYPE.get(key) : null;
                        if (damageType != null) {
                            typeSet = RegistrySet.keySetFromValues((RegistryKey)RegistryKey.DAMAGE_TYPE, List.of(damageType));
                        }
                    } else if (selector.getMany() != null && !selector.getMany().isEmpty()) {
                        List<DamageType> damageTypes = selector.getMany().stream().map(entry -> {
                            Object typeKey = entry.toLowerCase(Locale.ROOT);
                            if (!((String)typeKey).contains(":")) {
                                typeKey = "minecraft:" + (String)typeKey;
                            }
                            return NamespacedKey.fromString((String)typeKey);
                        }).filter(Objects::nonNull).map(arg_0 -> ((Registry)Registry.DAMAGE_TYPE).get(arg_0)).filter(Objects::nonNull).toList();
                        if (!damageTypes.isEmpty()) {
                            typeSet = RegistrySet.keySetFromValues((RegistryKey)RegistryKey.DAMAGE_TYPE, damageTypes);
                        }
                    }
                    if (typeSet == null) {
                        MythicLogger.error("BlocksAttacks component has an invalid DamageReduction.Type: {0}", selector);
                        continue;
                    }
                    reductionBuilder.type(typeSet);
                    reductionBuilder.base(reduction.getBase());
                    reductionBuilder.factor(reduction.getFactor());
                    reductionBuilder.horizontalBlockingAngle(reduction.getHorizontalBlockingAngle());
                    componentBuilder.addDamageReduction((DamageReduction)reductionBuilder.build());
                }
            }
            if (componentConfig.getItemDamage() != null) {
                AbstractItemBlocksAttacksComponent.ItemDamage itemDamageConfig = componentConfig.getItemDamage();
                ItemDamageFunction.Builder itemDamageBuilder = ItemDamageFunction.itemDamageFunction();
                if (itemDamageConfig.getThreshold() != null) {
                    itemDamageBuilder.threshold(itemDamageConfig.getThreshold().floatValue());
                }
                if (itemDamageConfig.getBase() != null) {
                    itemDamageBuilder.base(itemDamageConfig.getBase().floatValue());
                }
                if (itemDamageConfig.getFactor() != null) {
                    itemDamageBuilder.factor(itemDamageConfig.getFactor().floatValue());
                }
                componentBuilder.itemDamage((ItemDamageFunction)itemDamageBuilder.build());
            }
            if (componentConfig.getHitBlockSound() != null) {
                try {
                    componentBuilder.blockSound(Key.key((String)componentConfig.getHitBlockSound().toString()));
                }
                catch (IllegalArgumentException ex) {
                    MythicLogger.error("BlocksAttacks component has an invalid HitBlockSound: {0}", componentConfig.getHitBlockSound());
                }
            }
            if (componentConfig.getDisabledSound() != null) {
                try {
                    componentBuilder.disableSound(Key.key((String)componentConfig.getDisabledSound().toString()));
                }
                catch (IllegalArgumentException ex) {
                    MythicLogger.error("BlocksAttacks component has an invalid DisabledSound: {0}", componentConfig.getDisabledSound());
                }
            }
            if (componentConfig.getBypassedBy() != null) {
                try {
                    componentBuilder.bypassedBy(TagKey.create((RegistryKey)RegistryKey.DAMAGE_TYPE, (Key)Key.key((String)componentConfig.getBypassedBy())));
                }
                catch (IllegalArgumentException ex) {
                    MythicLogger.error("BlocksAttacks component has an invalid BypassedBy tag: {0}", componentConfig.getBypassedBy());
                }
            }
            this.itemStack.setData(DataComponentTypes.BLOCKS_ATTACKS, (Object)((BlocksAttacks)componentBuilder.build()));
        }
        return this;
    }

    @Override
    public AbstractItemStack applyGliderComponent(DropMetadata dropMetadata, AbstractItemGliderComponent abstractItemGliderComponent) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_3)) {
            this.itemStack.setData(DataComponentTypes.GLIDER);
        }
        return this;
    }

    @Override
    public AbstractItemStack applyRepairableComponent(DropMetadata dropMetadata, AbstractItemRepairableComponent abstractItemRepairableComponent) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_5)) {
            if (abstractItemRepairableComponent.getItemTypes() == null || abstractItemRepairableComponent.getItemTypes().isEmpty()) {
                return this;
            }
            List<ItemType> items = abstractItemRepairableComponent.getItemTypes().stream().map(entry -> {
                NamespacedKey key;
                Object itemKey = entry.toLowerCase(Locale.ROOT);
                if (!((String)itemKey).contains(":")) {
                    itemKey = "minecraft:" + (String)itemKey;
                }
                return (key = NamespacedKey.fromString((String)itemKey)) != null ? (ItemType)Registry.ITEM.get(key) : null;
            }).filter(Objects::nonNull).toList();
            if (items.isEmpty()) {
                MythicLogger.error("Repairable component has no valid item types configured");
                return this;
            }
            RegistryKeySet typeSet = RegistrySet.keySetFromValues((RegistryKey)RegistryKey.ITEM, items);
            this.itemStack.setData(DataComponentTypes.REPAIRABLE, (Object)Repairable.repairable((RegistryKeySet)typeSet));
        }
        return this;
    }

    @Override
    public AbstractItemStack applyPotDecorationsComponent(DropMetadata dropMetadata, AbstractItemPotDecorationsComponent componentConfig) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_5)) {
            PotDecorations.Builder decorationsBuilder = PotDecorations.potDecorations();
            boolean appliedAny = false;
            if (componentConfig.getBack() != null) {
                ItemType back = this.resolveItemType(componentConfig.getBack(), "PotDecorations.Back");
                if (back != null) {
                    decorationsBuilder.back(back);
                    appliedAny = true;
                } else {
                    return this;
                }
            }
            if (componentConfig.getLeft() != null) {
                ItemType left = this.resolveItemType(componentConfig.getLeft(), "PotDecorations.Left");
                if (left != null) {
                    decorationsBuilder.left(left);
                    appliedAny = true;
                } else {
                    return this;
                }
            }
            if (componentConfig.getRight() != null) {
                ItemType right = this.resolveItemType(componentConfig.getRight(), "PotDecorations.Right");
                if (right != null) {
                    decorationsBuilder.right(right);
                    appliedAny = true;
                } else {
                    return this;
                }
            }
            if (componentConfig.getFront() != null) {
                ItemType front = this.resolveItemType(componentConfig.getFront(), "PotDecorations.Front");
                if (front != null) {
                    decorationsBuilder.front(front);
                    appliedAny = true;
                } else {
                    return this;
                }
            }
            if (appliedAny) {
                this.itemStack.setData(DataComponentTypes.POT_DECORATIONS, (Object)((PotDecorations)decorationsBuilder.build()));
            }
        }
        return this;
    }

    @Override
    public AbstractItemStack applyOminousBottleAmplifierComponent(DropMetadata dropMetadata, AbstractItemOminousBottleAmplifierComponent componentConfig) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_5)) {
            if (componentConfig.getAmplifier() == null) {
                return this;
            }
            this.itemStack.setData(DataComponentTypes.OMINOUS_BOTTLE_AMPLIFIER, (Object)OminousBottleAmplifier.amplifier((int)componentConfig.getAmplifier()));
        }
        return this;
    }

    @Override
    public AbstractItemStack applyBucketEntityDataComponent(DropMetadata dropMetadata, AbstractItemBucketEntityDataComponent componentConfig) {
        return this;
    }

    @Override
    public AbstractItemStack applyPiercingWeaponComponent(DropMetadata dropMetadata, AbstractItemPiercingWeaponComponent componentConfig) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_5)) {
            PiercingWeapon.Builder componentBuilder = PiercingWeapon.piercingWeapon();
            if (componentConfig.getDealsKnockback() != null) {
                componentBuilder.dealsKnockback(componentConfig.getDealsKnockback().booleanValue());
            }
            if (componentConfig.getDismounts() != null) {
                componentBuilder.dismounts(componentConfig.getDismounts().booleanValue());
            }
            if (componentConfig.getSound() != null) {
                try {
                    componentBuilder.sound(Key.key((String)componentConfig.getSound()));
                }
                catch (IllegalArgumentException ex) {
                    MythicLogger.error("PiercingWeapon component has an invalid Sound: {0}", componentConfig.getSound());
                }
            }
            if (componentConfig.getHitSound() != null) {
                try {
                    componentBuilder.hitSound(Key.key((String)componentConfig.getHitSound()));
                }
                catch (IllegalArgumentException ex) {
                    MythicLogger.error("PiercingWeapon component has an invalid HitSound: {0}", componentConfig.getHitSound());
                }
            }
            this.itemStack.setData(DataComponentTypes.PIERCING_WEAPON, (Object)((PiercingWeapon)componentBuilder.build()));
        }
        return this;
    }

    @Override
    public AbstractItemStack applyDeathProtectionComponent(DropMetadata dropMetadata, AbstractItemDeathProtectionComponent component) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_3)) {
            PaperItemDeathProtectionComponent consumableData = (PaperItemDeathProtectionComponent)component;
            DeathProtection.Builder consumableBuilder = DeathProtection.deathProtection();
            if (consumableData.getConsumeEffects() != null) {
                consumableBuilder.addEffects(consumableData.getConsumeEffects());
            }
            this.itemStack.setData(DataComponentTypes.DEATH_PROTECTION, (DataComponentBuilder)consumableBuilder);
        }
        return this;
    }

    @Override
    public AbstractItemStack applyAttackRangeComponent(DropMetadata dropMetadata, AbstractItemAttackRangeComponent componentConfig) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_11)) {
            AttackRange.Builder componentBuilder = AttackRange.attackRange();
            if (componentConfig.getMinReach() != null) {
                componentBuilder.minReach(componentConfig.getMinReach().floatValue());
            }
            if (componentConfig.getMaxReach() != null) {
                componentBuilder.maxReach(componentConfig.getMaxReach().floatValue());
            }
            if (componentConfig.getMinCreativeReach() != null) {
                componentBuilder.minCreativeReach(componentConfig.getMinCreativeReach().floatValue());
            }
            if (componentConfig.getMaxCreativeReach() != null) {
                componentBuilder.maxCreativeReach(componentConfig.getMaxCreativeReach().floatValue());
            }
            if (componentConfig.getHitboxMargin() != null) {
                componentBuilder.hitboxMargin(componentConfig.getHitboxMargin().floatValue());
            }
            if (componentConfig.getMobFactor() != null) {
                componentBuilder.mobFactor(componentConfig.getMobFactor().floatValue());
            }
            this.itemStack.setData(DataComponentTypes.ATTACK_RANGE, (Object)((AttackRange)componentBuilder.build()));
        }
        return this;
    }

    @Override
    public AbstractItemStack applyEnchantableComponent(DropMetadata dropMetadata, AbstractItemEnchantableComponent componentConfig) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
            if (componentConfig.getValue() == null) {
                return this;
            }
            this.itemStack.setData(DataComponentTypes.ENCHANTABLE, (Object)Enchantable.enchantable((int)componentConfig.getValue()));
        }
        return this;
    }

    @Override
    public AbstractItemStack applyWeaponComponent(DropMetadata dropMetadata, AbstractItemWeaponComponent componentConfig) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
            Weapon.Builder componentBuilder = Weapon.weapon();
            if (componentConfig.getItemDamagePerAttack() != null) {
                componentBuilder.itemDamagePerAttack(componentConfig.getItemDamagePerAttack().intValue());
            }
            if (componentConfig.getDisableBlockingForSeconds() != null) {
                componentBuilder.disableBlockingForSeconds(componentConfig.getDisableBlockingForSeconds().floatValue());
            }
            this.itemStack.setData(DataComponentTypes.WEAPON, (Object)((Weapon)componentBuilder.build()));
        }
        return this;
    }

    @Override
    public AbstractItemStack applyKineticWeaponComponent(DropMetadata dropMetadata, AbstractItemKineticWeaponComponent componentConfig) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_11)) {
            KineticWeapon.Builder componentBuilder = KineticWeapon.kineticWeapon();
            if (componentConfig.getContactCooldownTicks() != null) {
                componentBuilder.contactCooldownTicks(componentConfig.getContactCooldownTicks().intValue());
            }
            if (componentConfig.getDelayTicks() != null) {
                componentBuilder.delayTicks(componentConfig.getDelayTicks().intValue());
            }
            if (componentConfig.getForwardMovement() != null) {
                componentBuilder.forwardMovement(componentConfig.getForwardMovement().floatValue());
            }
            if (componentConfig.getDamageMultiplier() != null) {
                componentBuilder.damageMultiplier(componentConfig.getDamageMultiplier().floatValue());
            }
            if (componentConfig.getSound() != null) {
                try {
                    componentBuilder.sound(Key.key((String)componentConfig.getSound()));
                }
                catch (IllegalArgumentException ex) {
                    MythicLogger.error("KineticWeapon component has an invalid Sound: {0}", componentConfig.getSound());
                }
            }
            if (componentConfig.getHitSound() != null) {
                try {
                    componentBuilder.hitSound(Key.key((String)componentConfig.getHitSound()));
                }
                catch (IllegalArgumentException ex) {
                    MythicLogger.error("KineticWeapon component has an invalid HitSound: {0}", componentConfig.getHitSound());
                }
            }
            if (componentConfig.getDamageConditions() != null) {
                componentBuilder.damageConditions(this.buildKineticWeaponCondition(componentConfig.getDamageConditions()));
            }
            if (componentConfig.getKnockbackConditions() != null) {
                componentBuilder.knockbackConditions(this.buildKineticWeaponCondition(componentConfig.getKnockbackConditions()));
            }
            if (componentConfig.getDismountConditions() != null) {
                componentBuilder.dismountConditions(this.buildKineticWeaponCondition(componentConfig.getDismountConditions()));
            }
            this.itemStack.setData(DataComponentTypes.KINETIC_WEAPON, (Object)((KineticWeapon)componentBuilder.build()));
        }
        return this;
    }

    private KineticWeapon.Condition buildKineticWeaponCondition(AbstractItemKineticWeaponComponent.ConditionConfig condition) {
        int maxDurationTicks = condition.getMaxDurationTicks() == null ? 0 : condition.getMaxDurationTicks();
        float minSpeed = condition.getMinSpeed() == null ? 0.0f : condition.getMinSpeed().floatValue();
        float minRelativeSpeed = condition.getMinRelativeSpeed() == null ? 0.0f : condition.getMinRelativeSpeed().floatValue();
        return KineticWeapon.condition((int)maxDurationTicks, (float)minSpeed, (float)minRelativeSpeed);
    }

    @Override
    public AbstractItemStack applyUseRemainderComponent(DropMetadata dropMetadata, AbstractItemUseRemainderComponent componentConfig) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
            ItemStack remainderItem = componentConfig.resolveRemainderItem(dropMetadata);
            if (remainderItem == null) {
                return this;
            }
            UseRemainder useRemainder = UseRemainder.useRemainder((ItemStack)remainderItem.clone());
            this.itemStack.setData(DataComponentTypes.USE_REMAINDER, (Object)useRemainder);
        }
        return this;
    }

    @Override
    public AbstractItemStack applyJukeboxPlayableComponent(DropMetadata dropMetadata, AbstractItemJukeboxPlayableComponent componentConfig) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_8)) {
            if (componentConfig.getSongKey() == null) {
                return this;
            }
            JukeboxSong song = (JukeboxSong)Registry.JUKEBOX_SONG.get(componentConfig.getSongKey());
            if (song == null) {
                MythicLogger.error("JukeboxPlayable Component has an invalid song key: {0}", componentConfig.getSongKey());
                return this;
            }
            JukeboxPlayable.Builder componentBuilder = JukeboxPlayable.jukeboxPlayable((JukeboxSong)song);
            this.itemStack.setData(DataComponentTypes.JUKEBOX_PLAYABLE, (Object)((JukeboxPlayable)componentBuilder.build()));
        }
        return this;
    }

    @Override
    public AbstractItemStack applyNoteBlockSoundComponent(DropMetadata dropMetadata, AbstractItemNoteBlockSoundComponent componentConfig) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_21_8)) {
            Key key = componentConfig.getKey();
            if (key == null) {
                return this;
            }
            this.itemStack.setData(DataComponentTypes.NOTE_BLOCK_SOUND, (Object)key);
        }
        return this;
    }

    @Override
    public AbstractItemStack applyBreakSoundComponent(DropMetadata dropMetadata, AbstractItemBreakSoundComponent componentConfig) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_20_5)) {
            Key key = componentConfig.getKey();
            if (key == null) {
                return this;
            }
            this.itemStack.setData(DataComponentTypes.BREAK_SOUND, (Object)key);
        }
        return this;
    }

    private ItemType resolveItemType(String entry, String fieldName) {
        ItemType item;
        if (entry == null || entry.isEmpty()) {
            MythicLogger.error("PotDecorations component has a missing value for {0}", fieldName);
            return null;
        }
        NamespacedKey key = NamespacedKey.fromString((String)entry);
        ItemType itemType = item = key != null ? (ItemType)Registry.ITEM.get(key) : null;
        if (item == null) {
            MythicLogger.error("PotDecorations component has an invalid item type for {0}: {1}", fieldName, entry);
        }
        return item;
    }
}

