/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_21_R7.ai.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.utils.serialize.Optl;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.ai.WrappedPathfindingGoal;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import io.lumine.mythic.core.volatilecode.v1_21_R7.ai.PathfinderHolder;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;

@MythicAIGoal(name="parentHurtBy", aliases={"parentHurtByTarget", "parentDamager", "parentAttacker"}, description="Target something that attacks the mob's parent")
public class ParentHurtByGoal
extends WrappedPathfindingGoal
implements PathfinderHolder {
    public ParentHurtByGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
    }

    @Override
    public boolean isValid() {
        return this.entity.isMob();
    }

    @Override
    public PathfinderGoal create() {
        return new MythicParentHurtTargetGoal(this.entity, (EntityInsentient)PathfinderHolder.getNMSEntity(this.entity));
    }

    public class MythicParentHurtTargetGoal
    extends PathfinderGoalTarget {
        private final AbstractEntity aiEntity;
        private ActiveMob activeMob;
        private WeakReference<EntityLiving> controllerEntity;
        private EntityLiving controllerLastHurt;
        private int timestamp;

        public MythicParentHurtTargetGoal(AbstractEntity aEntity, EntityInsentient mob) {
            super(mob, false);
            this.activeMob = null;
            this.controllerEntity = null;
            this.aiEntity = aEntity;
            this.a(EnumSet.of(PathfinderGoal.Type.d));
        }

        public boolean b() {
            EntityLiving controller;
            if (this.activeMob == null) {
                this.activeMob = ParentHurtByGoal.getPlugin().getMobManager().getMythicMobInstance(this.aiEntity);
                if (this.activeMob == null) {
                    return false;
                }
            }
            if ((controller = this.getControllerEntity()) == null) {
                return false;
            }
            this.controllerLastHurt = controller.eK();
            int i = controller.eM();
            return i != this.timestamp && this.a(this.controllerLastHurt, PathfinderTargetCondition.a);
        }

        public void d() {
            ((Mob)this.aiEntity.getBukkitEntity()).setTarget((LivingEntity)this.controllerLastHurt.getBukkitEntity());
            EntityLiving entityliving = this.getControllerEntity();
            if (entityliving != null) {
                this.timestamp = entityliving.eM();
            }
            super.d();
        }

        private EntityLiving getControllerEntity() {
            if (this.controllerEntity != null && this.controllerEntity.get() != null) {
                return (EntityLiving)this.controllerEntity.get();
            }
            Optl<AbstractEntity> maybeParent = this.activeMob.getParent();
            if (maybeParent.isPresent()) {
                AbstractEntity aEntity = maybeParent.get();
                Entity nmsEntity = ((CraftEntity)aEntity.getBukkitEntity()).getHandle();
                if (nmsEntity == null) {
                    return null;
                }
                if (nmsEntity instanceof EntityLiving) {
                    EntityLiving livingEntity = (EntityLiving)nmsEntity;
                    this.controllerEntity = new WeakReference<EntityLiving>(livingEntity);
                    return livingEntity;
                }
            }
            return null;
        }
    }
}

