/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_21_R7;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractBiome;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.adapters.AbstractStructure;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.api.volatilecode.handlers.VolatileWorldHandler;
import io.lumine.mythic.api.volatilecode.virtual.PacketArmorStand;
import io.lumine.mythic.api.volatilecode.virtual.PacketBlockDisplay;
import io.lumine.mythic.api.volatilecode.virtual.PacketFallingBlock;
import io.lumine.mythic.api.volatilecode.virtual.PacketItem;
import io.lumine.mythic.api.volatilecode.virtual.PacketItemDisplay;
import io.lumine.mythic.api.volatilecode.virtual.PacketTextDisplay;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.lib.lang3.Validate;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.volatilecode.v1_21_R7.VolatileBiomeImpl;
import io.lumine.mythic.core.volatilecode.v1_21_R7.VolatileStructureImpl;
import io.lumine.mythic.core.volatilecode.v1_21_R7.virtual.VirtualArmorStand;
import io.lumine.mythic.core.volatilecode.v1_21_R7.virtual.VirtualDisplayBlock;
import io.lumine.mythic.core.volatilecode.v1_21_R7.virtual.VirtualDisplayItem;
import io.lumine.mythic.core.volatilecode.v1_21_R7.virtual.VirtualFallingBlock;
import io.lumine.mythic.core.volatilecode.v1_21_R7.virtual.VirtualItem;
import io.lumine.mythic.core.volatilecode.v1_21_R7.virtual.VirtualTextDisplay;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R7.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class VolatileWorldHandlerImpl
implements VolatileWorldHandler {
    private static Method entityGetter;
    private final Map<BiomeBase, AbstractBiome> biomeMap = Maps.newConcurrentMap();
    private final Map<String, AbstractBiome> biomeLookup = Maps.newConcurrentMap();
    private final Map<Structure, AbstractStructure> structureMap = Maps.newConcurrentMap();
    private final Map<String, AbstractStructure> structureLookup = Maps.newConcurrentMap();

    public VolatileWorldHandlerImpl(VolatileCodeHandler handler) {
        CraftServer craftServer = (CraftServer)Bukkit.getServer();
        Optional maybeBiomeRegistry = craftServer.getHandle().b().bc().a(Registries.aS);
        if (maybeBiomeRegistry.isEmpty()) {
            MythicLogger.error("BiomeRegistry not found");
            return;
        }
        IRegistry biomeRegistry = (IRegistry)maybeBiomeRegistry.get();
        biomeRegistry.k().forEach(entry -> {
            String key = ((ResourceKey)entry.getKey()).a().toString();
            int id = biomeRegistry.a((Object)((BiomeBase)entry.getValue()));
            BiomeBase biome = (BiomeBase)entry.getValue();
            VolatileBiomeImpl volatileBiome = new VolatileBiomeImpl(this, id, key, (Holder<BiomeBase>)biomeRegistry.b((ResourceKey)entry.getKey()));
            this.biomeMap.put(biome, volatileBiome);
            this.biomeLookup.put(key, volatileBiome);
        });
        Optional maybeStructureRegistry = craftServer.getHandle().b().bc().a(Registries.bs);
        if (maybeStructureRegistry.isEmpty()) {
            MythicLogger.error("StructureRegistry not found");
            return;
        }
        IRegistry structureRegistry = (IRegistry)maybeStructureRegistry.get();
        structureRegistry.k().forEach(entry -> {
            String key = ((ResourceKey)entry.getKey()).a().toString();
            int id = structureRegistry.a((Object)((Structure)entry.getValue()));
            Structure structure = (Structure)entry.getValue();
            VolatileStructureImpl volatileStructure = new VolatileStructureImpl(this, id, key, (Holder.c<Structure>)structureRegistry.b((ResourceKey)entry.getKey()), structure);
            this.structureMap.put(structure, volatileStructure);
            this.structureLookup.put(key, volatileStructure);
        });
    }

    @Override
    public void playSoundAtLocation(AbstractLocation location, String sound, float volume, float pitch, double radius) {
        Location l = BukkitAdapter.adapt(location);
        l.getWorld().playSound(l, sound, volume, pitch);
    }

    @Override
    public boolean isChunkLoaded(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        return null != nmsWorld.getChunkIfLoaded(x, z);
    }

    private LevelEntityGetter<net.minecraft.world.entity.Entity> getEntityGetter(WorldServer level) {
        if (entityGetter == null) {
            return level.M.e();
        }
        try {
            return (LevelEntityGetter)entityGetter.invoke((Object)level, new Object[0]);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public Collection<AbstractEntity> getEntities(AbstractWorld world) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        ArrayList ret = Lists.newArrayList();
        for (net.minecraft.world.entity.Entity entity : this.getEntityGetter(nmsWorld).a()) {
            ret.add(BukkitAdapter.adapt((Entity)entity.getBukkitEntity()));
        }
        return ret;
    }

    @Override
    public Collection<AbstractEntity> getLivingEntities(AbstractWorld world) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        ArrayList ret = Lists.newArrayList();
        for (net.minecraft.world.entity.Entity entity : this.getEntityGetter(nmsWorld).a()) {
            if (!(entity instanceof EntityLiving)) continue;
            ret.add(BukkitAdapter.adapt((Entity)entity.getBukkitEntity()));
        }
        return ret;
    }

    @Override
    public Collection<AbstractPlayer> getPlayers(AbstractWorld world) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        ArrayList ret = Lists.newArrayList();
        for (EntityPlayer entity : nmsWorld.E()) {
            ret.add(BukkitAdapter.adapt((Player)entity.getBukkitEntity()));
        }
        return ret;
    }

    @Override
    public int getEntitiesInChunk(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        Chunk chunk = nmsWorld.getChunkIfLoaded(x, z);
        if (chunk == null) {
            return 0;
        }
        CraftChunk craftChunk = new CraftChunk(chunk);
        return craftChunk.getEntities().length;
    }

    @Override
    public Collection<AbstractBiome> getBiomes() {
        return Collections.unmodifiableCollection(this.biomeMap.values());
    }

    @Override
    public Optional<AbstractBiome> getBiome(String key) {
        if (!((String)key).contains(":")) {
            key = "minecraft:" + (String)key;
        }
        key = ((String)key).toLowerCase();
        return Optional.ofNullable(this.biomeLookup.getOrDefault(key, null));
    }

    @Override
    public AbstractBiome getBiome(AbstractLocation target) {
        Location location = BukkitAdapter.adapt(target);
        BlockPosition blockPosition = new BlockPosition(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        CraftWorld bukkitWorld = (CraftWorld)location.getWorld();
        WorldServer server = bukkitWorld.getHandle();
        BiomeBase biome = (BiomeBase)server.H_().a(blockPosition).a();
        return this.biomeMap.getOrDefault(biome, null);
    }

    @Override
    public Collection<AbstractStructure> getStructures() {
        return Collections.unmodifiableCollection(this.structureMap.values());
    }

    @Override
    public Optional<AbstractStructure> getStructure(String key) {
        if (!((String)key).contains(":")) {
            key = "minecraft:" + (String)key;
        }
        key = ((String)key).toLowerCase();
        return Optional.ofNullable(this.structureLookup.getOrDefault(key, null));
    }

    @Override
    public Collection<AbstractStructure> getStructures(AbstractLocation target) {
        Location location = BukkitAdapter.adapt(target);
        BlockPosition blockPosition = new BlockPosition(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        CraftWorld bukkitWorld = (CraftWorld)location.getWorld();
        WorldServer server = bukkitWorld.getHandle();
        Set structures = server.b().b(blockPosition).keySet();
        ArrayList ret = Lists.newArrayList();
        block0: for (Structure struct : structures) {
            StructureStart start = server.b().a(blockPosition, struct);
            for (StructurePiece piece : start.i()) {
                StructureBoundingBox bb = piece.f();
                if (!bb.b((BaseBlockPosition)blockPosition)) continue;
                ret.add(this.structureMap.get(struct));
                continue block0;
            }
        }
        return ret;
    }

    @Override
    public float getDifficultyScale(AbstractLocation location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        DifficultyDamageScaler scaler = ((CraftWorld)location.getWorld()).getHandle().c(pos);
        return scaler.b();
    }

    @Override
    public Collection<AbstractEntity> getEntitiesNearLocation(AbstractLocation location, double radius, Predicate<AbstractEntity> predicate) {
        ObjectArrayList entities = new ObjectArrayList();
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(location.getWorld());
        WorldServer nmsWorld = bukkitWorld.getHandle();
        double rawX = location.getX();
        double rawZ = location.getZ();
        if (Double.isInfinite(rawX) || Double.isInfinite(rawZ)) {
            Log.warn("getEntitiesNearLocation: invalid location (\u221e/NaN) \u2192 X={0}, Z={0}", rawX, rawZ);
            return Collections.emptyList();
        }
        int smallX = Numbers.floor((rawX - radius) / 16.0);
        int bigX = Numbers.floor((rawX + radius) / 16.0);
        int smallZ = Numbers.floor((rawZ - radius) / 16.0);
        int bigZ = Numbers.floor((rawZ + radius) / 16.0);
        for (int x = smallX; x <= bigX; ++x) {
            for (int z = smallZ; z <= bigZ; ++z) {
                Chunk chunk = nmsWorld.getChunkIfLoaded(x, z);
                if (null == chunk) continue;
                CraftChunk craftChunk = new CraftChunk(chunk);
                for (Entity e : craftChunk.getEntities()) {
                    AbstractEntity entity = BukkitAdapter.adapt(e);
                    if (predicate != null && !predicate.test(entity)) continue;
                    entities.add(entity);
                }
            }
        }
        return entities;
    }

    @Override
    public RayTraceResult rayTraceBlock(AbstractLocation start, AbstractLocation end, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        RayTrace.FluidCollisionOption fluidCollisionOption;
        World world = BukkitAdapter.adapt(start).getWorld();
        if (world == null) {
            return null;
        }
        WorldServer level = ((CraftWorld)world).getHandle();
        Vec3D startPos = new Vec3D(start.getX(), start.getY(), start.getZ());
        Vec3D endPos = new Vec3D(end.getX(), end.getY(), end.getZ());
        if (fluidCollisionMode == null) {
            fluidCollisionOption = null;
        } else {
            switch (fluidCollisionMode) {
                case ALWAYS: {
                    fluidCollisionOption = RayTrace.FluidCollisionOption.c;
                    break;
                }
                case SOURCE_ONLY: {
                    fluidCollisionOption = RayTrace.FluidCollisionOption.b;
                    break;
                }
                case NEVER: {
                    fluidCollisionOption = RayTrace.FluidCollisionOption.a;
                    break;
                }
                default: {
                    fluidCollisionOption = null;
                }
            }
        }
        RayTrace.FluidCollisionOption nmsFluidCollisionMode = fluidCollisionOption;
        MovingObjectPositionBlock nmsHitResult = level.a(new RayTrace(startPos, endPos, ignorePassableBlocks ? RayTrace.BlockCollisionOption.a : RayTrace.BlockCollisionOption.b, nmsFluidCollisionMode, (net.minecraft.world.entity.Entity)null));
        if (nmsHitResult != null && nmsHitResult.d() != MovingObjectPosition.EnumMovingObjectType.a) {
            Vec3D nmsHitPos = nmsHitResult.g();
            Vector hitPosition = new Vector(nmsHitPos.g, nmsHitPos.h, nmsHitPos.i);
            BlockFace hitBlockFace = null;
            if (nmsHitResult.d() == MovingObjectPosition.EnumMovingObjectType.c) {
                CraftEntity hitEntity = ((MovingObjectPositionEntity)nmsHitResult).a().getBukkitEntity();
                return new RayTraceResult(hitPosition, (Entity)hitEntity, (BlockFace)null);
            }
            Block hitBlock = null;
            BlockPosition nmsBlockPos = null;
            if (nmsHitResult.d() == MovingObjectPosition.EnumMovingObjectType.b) {
                MovingObjectPositionBlock blockHitResult = nmsHitResult;
                hitBlockFace = CraftBlock.notchToBlockFace((EnumDirection)blockHitResult.c());
                nmsBlockPos = blockHitResult.b();
            }
            if (nmsBlockPos != null && world != null) {
                hitBlock = world.getBlockAt(nmsBlockPos.u(), nmsBlockPos.v(), nmsBlockPos.w());
            }
            return new RayTraceResult(hitPosition, hitBlock, hitBlockFace);
        }
        return null;
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> filter) {
        Validate.notNull(start, "Start location is null!", new Object[0]);
        start.checkFinite();
        Validate.notNull(direction, "Direction is null!", new Object[0]);
        direction.checkFinite();
        Validate.isTrue(direction.lengthSquared() > 0.0, "Direction's magnitude is 0!", new Object[0]);
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir).expand(raySize);
        Collection entities = start.getWorld().getNearbyEntities(aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    @Override
    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, double raySize, Predicate<Entity> entityFilter, Predicate<Material> blockFilter) {
        double distance;
        if (direction.lengthSquared() < 1.0E-5 || maxDistance <= 1.0E-5) {
            return null;
        }
        RayTraceResult blockRayTrace = null;
        RayTraceResult entityRayTrace = start.getWorld().rayTraceEntities(start, direction, maxDistance, raySize, entityFilter);
        if (entityRayTrace != null && entityRayTrace.getHitEntity() != null) {
            distance = start.distance(entityRayTrace.getHitEntity().getLocation());
            if (distance == 0.0) {
                distance = maxDistance;
            }
        } else {
            distance = maxDistance;
        }
        BlockIterator bIterator = new BlockIterator(start.getWorld(), start.toVector(), direction, 0.0, (int)Math.ceil(distance));
        Block block = null;
        while (bIterator.hasNext()) {
            RayTraceResult res;
            block = bIterator.next();
            if (block.isEmpty() || blockFilter.test(block.getType()) || (res = block.rayTrace(start, direction, distance, fluidCollisionMode)) == null) continue;
            blockRayTrace = res;
            break;
        }
        if (entityRayTrace != null && entityRayTrace.getHitEntity() != null) {
            if (blockRayTrace != null) {
                return blockRayTrace;
            }
            return entityRayTrace;
        }
        if (blockRayTrace != null) {
            return blockRayTrace;
        }
        if (entityRayTrace != null) {
            return new RayTraceResult(entityRayTrace.getHitPosition());
        }
        return new RayTraceResult(start.toVector().add(direction.clone().normalize().multiply(maxDistance)));
    }

    @Override
    public Entity spawnInvisibleArmorStand(Location location) {
        WorldServer w = ((CraftWorld)location.getWorld()).getHandle();
        EntityArmorStand nmsEntity = new EntityArmorStand((net.minecraft.world.level.World)w, location.getX(), location.getY(), location.getZ());
        nmsEntity.a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        nmsEntity.l(true);
        w.b((net.minecraft.world.entity.Entity)nmsEntity);
        return nmsEntity.getBukkitEntity();
    }

    @Override
    public PacketArmorStand.PacketArmorStandEntityRenderer createVirtualArmorStandRenderer(PacketArmorStand wrapper) {
        return new VirtualArmorStand(wrapper);
    }

    @Override
    public PacketFallingBlock.PacketFallingBlockEntityRenderer createVirtualBlockRenderer(PacketFallingBlock wrapper) {
        return new VirtualFallingBlock(wrapper);
    }

    @Override
    public PacketItem.PacketItemEntityRenderer createVirtualItemRenderer(PacketItem wrapper) {
        return new VirtualItem(wrapper);
    }

    @Override
    public PacketBlockDisplay.PacketBlockDisplayEntityRenderer createVirtualDisplayBlockEntityRenderer(PacketBlockDisplay wrapper) {
        return new VirtualDisplayBlock(wrapper);
    }

    @Override
    public PacketItemDisplay.PacketItemDisplayEntityRenderer createVirtualDisplayItemEntityRenderer(PacketItemDisplay wrapper) {
        return new VirtualDisplayItem(wrapper);
    }

    @Override
    public PacketTextDisplay.PacketTextDisplayEntityRenderer createVirtualTextDisplayEntityRenderer(PacketTextDisplay wrapper) {
        return new VirtualTextDisplay(wrapper);
    }

    static {
        for (Method method : WorldServer.class.getMethods()) {
            if (!LevelEntityGetter.class.isAssignableFrom(method.getReturnType()) || method.getReturnType() == LevelEntityGetter.class) continue;
            entityGetter = method;
            break;
        }
    }
}

