/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_21_R6.ai.targeters;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.mobs.ai.WrappedPathfindingGoal;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import io.lumine.mythic.core.volatilecode.v1_21_R6.ai.PathfinderHolder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import org.bukkit.entity.Entity;

@MythicAIGoal(name="nearestSpecificFactionMonsters", aliases={"specificFactionMonsters"}, description="Target a nearby monster that is in a specific faction")
public class SpecificFactionMonstersGoal
extends WrappedPathfindingGoal
implements PathfinderHolder {
    private Set<String> faction = Sets.newHashSet();

    public SpecificFactionMonstersGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
        String[] split;
        String factions = mlc.getString(new String[]{"faction", "f"}, this.dataVar1, new String[0]);
        if (factions == null) {
            return;
        }
        for (String s2 : split = factions.split(",")) {
            this.faction.add(s2.toUpperCase());
        }
    }

    @Override
    public boolean isValid() {
        return this.entity.isCreature();
    }

    @Override
    public PathfinderGoal create() {
        return new PathfinderGoalNearestAttackableTarget((EntityInsentient)PathfinderHolder.getNMSEntity(this.entity), EntityMonster.class, 0, true, false, (targetEntity, serverLevel) -> {
            try {
                ActiveMob mob = SpecificFactionMonstersGoal.getPlugin().getMobManager().getMythicMobInstance(this.getEntity());
                AbstractEntity target = BukkitAdapter.adapt((Entity)targetEntity.getBukkitEntity());
                if (mob == null) {
                    return false;
                }
                if (target.isPlayer()) {
                    for (String faction : this.faction) {
                        if (!SpecificFactionMonstersGoal.getPlugin().getPlayerManager().getFactionProvider().isInFaction(target.asPlayer(), faction)) continue;
                        return true;
                    }
                } else {
                    Optional<ActiveMob> maybeTargetAM = SpecificFactionMonstersGoal.getPlugin().getMobManager().getActiveMob(target.getUniqueId());
                    if (!maybeTargetAM.isPresent()) {
                        return false;
                    }
                    ActiveMob targetAM = maybeTargetAM.get();
                    if (targetAM.hasFaction()) {
                        String faction = targetAM.getFaction().toUpperCase();
                        return this.faction.contains(faction);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        });
    }
}

