/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_21_R3.ai.goals;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.core.mobs.ai.WrappedPathfindingGoal;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import io.lumine.mythic.core.volatilecode.v1_21_R3.ai.PathfinderHolder;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3D;

@MythicAIGoal(name="moveWithinDistanceOfTarget", aliases={"moveWithin"}, description="Moves towards the target to be within a certain range")
public class MoveWithinGoal
extends WrappedPathfindingGoal
implements PathfinderHolder {
    private double speedModifier;
    private double minRangeSq;
    private double maxRangeSq;

    public MoveWithinGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
        this.speedModifier = mlc.getDouble(new String[]{"speed", "s"}, 1.0);
        double minRange = mlc.getDouble(new String[]{"minrange", "minrange", "range", "r", "distance", "d"}, 10.0);
        double maxRange = mlc.getDouble(new String[]{"maxrange", "maxrange", "maxr"}, 32.0);
        this.minRangeSq = minRange * minRange;
        this.maxRangeSq = maxRange * maxRange;
    }

    @Override
    public boolean isValid() {
        return this.entity.isCreature();
    }

    @Override
    public PathfinderGoal create() {
        return new MoveWithinDistanceOfTargetGoal(PathfinderHolder.getNMSEntity(this.entity));
    }

    public class MoveWithinDistanceOfTargetGoal
    extends PathfinderGoal {
        private final EntityCreature mob;
        @Nullable
        private EntityLiving target;
        private double wantedX;
        private double wantedY;
        private double wantedZ;

        public MoveWithinDistanceOfTargetGoal(EntityCreature mob) {
            this.mob = mob;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        public boolean b() {
            this.target = this.mob.O_();
            if (this.target == null) {
                return false;
            }
            double distance = this.target.g((Entity)this.mob);
            if (distance < MoveWithinGoal.this.minRangeSq || distance > MoveWithinGoal.this.maxRangeSq) {
                return false;
            }
            Vec3D moveTo = DefaultRandomPos.a((EntityCreature)this.mob, (int)16, (int)7, (Vec3D)this.target.dt(), (double)1.5707963705062866);
            if (moveTo == null) {
                return false;
            }
            this.wantedX = moveTo.d;
            this.wantedY = moveTo.e;
            this.wantedZ = moveTo.f;
            return true;
        }

        public boolean c() {
            if (this.mob.P().k() || this.target == null || !this.target.bL()) {
                return false;
            }
            double distance = this.target.g((Entity)this.mob);
            return !(distance < MoveWithinGoal.this.minRangeSq) && !(distance > MoveWithinGoal.this.maxRangeSq);
        }

        public void e() {
            this.target = null;
        }

        public void d() {
            this.mob.P().a(this.wantedX, this.wantedY, this.wantedZ, MoveWithinGoal.this.speedModifier);
        }
    }
}

