/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.volatilecode.v1_20_R3.ai.goals;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.core.mobs.ai.WrappedPathfindingGoal;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicAIGoal;
import io.lumine.mythic.core.volatilecode.v1_20_R3.ai.PathfinderHolder;
import java.util.List;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsTarget;

@MythicAIGoal(name="moveTowardsTargetConditional", aliases={"moveTowardsTargetCond"}, description="Path to the current target")
public class MoveTowardsConditionalGoal
extends WrappedPathfindingGoal
implements PathfinderHolder {
    private double speedModifier;
    private float maxRange;
    protected List<SkillCondition> targetConditions = null;

    public MoveTowardsConditionalGoal(AbstractEntity entity, String line, MythicLineConfig mlc) {
        super(entity, line, mlc);
        this.speedModifier = mlc.getDouble(new String[]{"speed", "s"}, 1.0);
        this.maxRange = mlc.getFloat(new String[]{"maxrange", "range", "r"}, 32.0f);
        String targetConditionString = mlc.getString(new String[]{"targetconditions", "conditions", "cond", "c"}, "null", new String[0]);
        if (targetConditionString != null) {
            this.targetConditions = MoveTowardsConditionalGoal.getPlugin().getSkillManager().getConditions(targetConditionString);
        }
    }

    @Override
    public boolean isValid() {
        return this.entity.isCreature();
    }

    @Override
    public PathfinderGoal create() {
        return new PathfinderGoalMoveTowardsTargetIf(PathfinderHolder.getNMSEntity(this.entity), this.speedModifier, this.maxRange);
    }

    public class PathfinderGoalMoveTowardsTargetIf
    extends PathfinderGoalMoveTowardsTarget {
        public PathfinderGoalMoveTowardsTargetIf(EntityCreature mob, double speedModifier, float maxRange) {
            super(mob, speedModifier, maxRange);
        }

        public boolean a() {
            boolean bool = super.a();
            if (bool) {
                return this.evaluateConditions();
            }
            return false;
        }

        public boolean b() {
            boolean bool = super.b();
            if (bool) {
                return this.evaluateConditions();
            }
            return false;
        }

        private boolean evaluateConditions() {
            try {
                AbstractEntity target = MoveTowardsConditionalGoal.this.entity.getTarget();
                if (target == null) {
                    return false;
                }
                for (SkillCondition cond : MoveTowardsConditionalGoal.this.targetConditions) {
                    if (cond.evaluateToEntity(MoveTowardsConditionalGoal.this.entity, target)) continue;
                    return false;
                }
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
    }
}

