/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.utils.string.replacer;

import com.roklenarcic.util.strings.AhoCorasickMap;
import com.roklenarcic.util.strings.MapMatchListener;
import io.lumine.mythic.core.utils.string.replacer.StringReplacer;
import java.util.ArrayList;
import java.util.Map;

public class AhoCorasickReplacer
extends StringReplacer {
    protected volatile boolean compiled = false;
    protected volatile AhoCorasickMap<String> replacer;

    @Override
    public void register(String key, String rep) {
        super.register(key, rep);
    }

    @Override
    public void unregister(String key) {
        super.unregister(key);
    }

    @Override
    public synchronized void compile() {
        this.uncompile();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry entry : this.dictionary.entrySet()) {
            keys.add((String)entry.getKey());
            values.add((String)entry.getValue());
        }
        this.replacer = new AhoCorasickMap(keys, values, true);
        this.compiled = true;
    }

    @Override
    public synchronized void uncompile() {
        this.replacer = null;
        this.compiled = false;
    }

    @Override
    public synchronized void clear() {
        this.dictionary.clear();
        this.uncompile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String replaceText(String text) {
        if (!this.compiled || this.replacer == null) {
            AhoCorasickReplacer ahoCorasickReplacer = this;
            synchronized (ahoCorasickReplacer) {
                if (!this.compiled || this.replacer == null) {
                    this.compile();
                }
            }
        }
        StringBuilder result = new StringBuilder();
        int[] lastEndPosition = new int[]{0};
        MapMatchListener<String> listener = (haystack1, startPosition, endPosition, replacementValue) -> {
            result.append(haystack1, lastEndPosition[0], startPosition);
            result.append((String)replacementValue);
            lastEndPosition[0] = endPosition;
            return true;
        };
        this.replacer.match(text, listener);
        result.append(text.substring(lastEndPosition[0]));
        return result.toString();
    }

    public boolean isCompiled() {
        return this.compiled;
    }
}

