/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.utils.physics;

import io.lumine.mythic.core.utils.physics.ComplexAABB;
import io.lumine.mythic.core.utils.physics.VectorMath;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class PhysicsBlock {
    private final Block block;

    public boolean uncertainCollidesWith(@NotNull BoundingBox boundingBox) {
        return !this.block.isPassable() && this.voxelIntersectsWith(boundingBox);
    }

    public boolean voxelIntersectsWith(@NotNull BoundingBox boundingBox) {
        return this.block.getBoundingBox().overlaps(boundingBox);
    }

    public boolean collidesWith(@NotNull BoundingBox boundingBox) {
        return !this.block.isPassable() && !ComplexAABB.getOverlaps(boundingBox, ComplexAABB.get(this.block)).isEmpty();
    }

    @NotNull
    public List<BlockFace> getCollidedFaces(@NotNull BoundingBox boundingBox) {
        long t2 = System.nanoTime();
        ArrayList<BlockFace> hitFaces = new ArrayList<BlockFace>();
        World world = this.block.getWorld();
        Location rayTraceOrigin = boundingBox.getCenter().toLocation(world);
        for (BoundingBox overlappedBoundingBox : ComplexAABB.getOverlaps(boundingBox, ComplexAABB.get(this.block))) {
            Vector rayTraceAngle = VectorMath.angleBetween(rayTraceOrigin.toVector(), overlappedBoundingBox.getCenter());
            RayTraceResult rayTraceResult = world.rayTraceBlocks(rayTraceOrigin, rayTraceAngle, 0.25, FluidCollisionMode.NEVER, true);
            if (rayTraceResult == null || rayTraceResult.getHitBlock() == null || rayTraceResult.getHitBlockFace() == null) continue;
            hitFaces.add(rayTraceResult.getHitBlockFace());
        }
        t2 = System.nanoTime() - t2;
        return hitFaces;
    }

    @NotNull
    public List<BlockFace> _getCollidedFaces(@NotNull BoundingBox boundingBox) {
        long t2 = System.nanoTime();
        ArrayList<BlockFace> hitFaces = new ArrayList<BlockFace>();
        for (BoundingBox overlappedBoundingBox : ComplexAABB.getOverlaps(boundingBox, ComplexAABB.get(this.block))) {
            BoundingBox intersection = overlappedBoundingBox.intersection(boundingBox);
            Vector intersectionCenter = intersection.getCenter();
            Vector boundingBoxCenter = boundingBox.getCenter();
            if (intersectionCenter.getX() > boundingBoxCenter.getX()) {
                hitFaces.add(BlockFace.WEST);
            } else if (intersectionCenter.getX() < boundingBoxCenter.getX()) {
                hitFaces.add(BlockFace.EAST);
            }
            if (intersectionCenter.getZ() > boundingBoxCenter.getZ()) {
                hitFaces.add(BlockFace.NORTH);
            } else if (intersectionCenter.getZ() < boundingBoxCenter.getZ()) {
                hitFaces.add(BlockFace.SOUTH);
            }
            if (intersectionCenter.getY() > boundingBoxCenter.getY()) {
                hitFaces.add(BlockFace.DOWN);
                continue;
            }
            if (!(intersectionCenter.getY() < boundingBoxCenter.getY())) continue;
            hitFaces.add(BlockFace.UP);
        }
        t2 = System.nanoTime() - t2;
        return hitFaces;
    }

    public PhysicsBlock(Block block) {
        this.block = block;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhysicsBlock)) {
            return false;
        }
        PhysicsBlock other = (PhysicsBlock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Block this$block = this.getBlock();
        Block other$block = other.getBlock();
        return !(this$block == null ? other$block != null : !this$block.equals(other$block));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PhysicsBlock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Block $block = this.getBlock();
        result = result * 59 + ($block == null ? 43 : $block.hashCode());
        return result;
    }

    public String toString() {
        return "PhysicsBlock(block=" + String.valueOf(this.getBlock()) + ")";
    }
}

