/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.utils;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.items.ItemExecutor;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.mobs.MobType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TemplateUtil {
    private static final ItemExecutor ITEM_EXECUTOR = MythicBukkit.inst().getItemManager();
    private static final MobExecutor MOB_EXECUTOR = MythicBukkit.inst().getMobManager();

    public static void handleTemplates(List<? extends Template> templates, Map<String, ?> registry) {
        HashMap stateMap = new HashMap();
        Map<String, Template> templateMap = templates.stream().collect(Collectors.toMap(Template::id, template -> template, (existing, replacement) -> existing));
        templates.forEach(template -> TemplateUtil.processTemplate(template, templateMap, stateMap, registry));
    }

    private static void processTemplate(Template template, Map<String, Template> templates, Map<String, NodeState> state, Map<String, ?> registry) {
        NodeState mergeState = state.getOrDefault(template.id(), NodeState.IDLE);
        if (mergeState == NodeState.BUSY) {
            MythicLogger.error("Cyclic template dependency found between {0} and {1}", template.id(), template.parentId());
            return;
        }
        if (mergeState == NodeState.FINISHED) {
            return;
        }
        state.put(template.id(), NodeState.BUSY);
        if (template.parentId() != null) {
            String[] parentIds = template.parentId().split(",");
            List<String> parentIdList = Arrays.asList(parentIds);
            Collections.reverse(parentIdList);
            for (String parentID : parentIdList) {
                Template parentTemplate = templates.get(parentID = parentID.trim());
                if (parentTemplate == null && registry.get(parentID) == null) {
                    MythicLogger.error("Invalid template used as parent in {0}: {1}", template.id(), parentID);
                    return;
                }
                if (parentTemplate != null) {
                    TemplateUtil.processTemplate(parentTemplate, templates, state, registry);
                }
                MythicConfig parentConfig = null;
                if (parentTemplate != null) {
                    parentConfig = parentTemplate.config();
                } else {
                    Object registryObj = registry.get(parentID);
                    if (registryObj instanceof MythicMob) {
                        MythicMob mob = (MythicMob)registryObj;
                        parentConfig = mob.getConfig();
                    } else if (registryObj instanceof MythicItem) {
                        MythicItem item = (MythicItem)registryObj;
                        parentConfig = item.getConfig();
                    } else if (registryObj instanceof TemplateMob) {
                        TemplateMob tmpl = (TemplateMob)registryObj;
                        parentConfig = tmpl.config();
                    } else if (registryObj instanceof TemplateItem) {
                        TemplateItem tmpl = (TemplateItem)registryObj;
                        parentConfig = tmpl.config();
                    }
                }
                if (parentConfig == null) continue;
                List<String> excludedFields = template.config().getStringList("Exclude");
                excludedFields.add("Hidden");
                template.config().merge(parentConfig, excludedFields);
                List<String> templateParents = template.config().getStringList("TemplateParents", new ArrayList<String>());
                templateParents.add(parentID);
                template.config().set("TemplateParents", templateParents);
            }
        }
        TemplateUtil.registerTemplate(template, registry);
        state.put(template.id(), NodeState.FINISHED);
    }

    private static void registerTemplate(Template template, Map<String, ?> registry) {
        if (template instanceof TemplateMob) {
            TemplateMob mob = (TemplateMob)template;
            MobType mm4 = new MobType(MOB_EXECUTOR, mob.pack(), mob.file(), mob.id(), mob.config());
            registry.put(mob.id(), mm4);
        } else if (template instanceof TemplateItem) {
            TemplateItem item = (TemplateItem)template;
            ITEM_EXECUTOR.registerItem(item.id(), new MythicItem(item.pack(), item.file(), item.id(), item.config()));
            item.pack().addItem();
        }
    }

    public static interface Template {
        public String id();

        public String parentId();

        public MythicConfig config();

        public Pack pack();

        public File file();
    }

    public static enum NodeState {
        IDLE,
        BUSY,
        FINISHED;

    }

    public record TemplateMob(File file, Pack pack, String id, MythicConfig config, String parentId) implements Template
    {
    }

    public record TemplateItem(File file, Pack pack, String id, MythicConfig config, String parentId) implements Template
    {
    }
}

