/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import com.google.common.base.Preconditions;
import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.interfaces.ContainingVariable;

public class StringVariable
extends Variable
implements ContainingVariable {
    private String value;
    public static final VariableInfo<String> variableInfo = VariableInfo.builder().clazz(StringVariable.class).type(VariableType.STRING).typeName("String").valueClass(String.class).objectConstructor(StringVariable::ofObject).polymorphicConstructor(StringVariable::of).toStringFunction(StringVariable::toString).fromStringFunction(StringVariable::fromString).build();

    public VariableInfo<String> getVariableInfo() {
        return variableInfo;
    }

    public static StringVariable of(PolymorphicPlaceholder data, PlaceholderContext context, long expirationTime) {
        return new StringVariable(data.getString(context), expirationTime);
    }

    public static String toString(String data) {
        return data;
    }

    public static String fromString(String data) {
        return data;
    }

    public static StringVariable ofObject(Object o, Long expirationTime) {
        if (o instanceof String) {
            String string = (String)o;
            return new StringVariable(string, expirationTime);
        }
        return new StringVariable(String.valueOf(o), expirationTime);
    }

    public StringVariable(String value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public StringVariable(String value, long expirationTime) {
        super(expirationTime);
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public String substring(int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end > this.value.length()) {
            end = this.value.length();
        }
        if (start >= this.value.length()) {
            return "";
        }
        if (start > end) {
            return "";
        }
        return this.value.substring(start, end);
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    public String getValueClone() {
        return this.value;
    }

    @Override
    public boolean executeAddition(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.value = this.value + data.getString(context);
        return true;
    }

    @Override
    public boolean executeSubtraction(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.value = this.value.replace(data.getString(context), "");
        return true;
    }

    @Override
    public boolean checkEquality(PolymorphicPlaceholder data, PlaceholderContext context) {
        return this.value.equals(data.getString(context));
    }

    @Override
    public boolean checkContainsAll(PolymorphicPlaceholder data, PlaceholderContext context) {
        return this.value.contains(data.getString(context));
    }

    @Override
    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringVariable)) {
            return false;
        }
        StringVariable other = (StringVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

