/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.interfaces.ContainingVariable;
import io.lumine.mythic.core.skills.variables.types.ListVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SetVariable
extends Variable
implements ContainingVariable {
    private Set<String> value = ConcurrentHashMap.newKeySet();
    public static final VariableInfo<Set> variableInfo = VariableInfo.builder().clazz(SetVariable.class).type(VariableType.SET).typeName("Set").valueClass(Set.class).objectConstructor(SetVariable::ofObject).polymorphicConstructor(SetVariable::of).toStringFunction(ListVariable::toString).fromStringFunction(SetVariable::fromString).formattedFunction(ListVariable::formatted).build();

    public VariableInfo<Set> getVariableInfo() {
        return variableInfo;
    }

    public static SetVariable of(PolymorphicPlaceholder data, PlaceholderContext context, long expirationTime) {
        return new SetVariable(data.getString(context), expirationTime);
    }

    public static Set<String> fromString(String data) {
        return new HashSet<String>(SetVariable.parse(data));
    }

    public static SetVariable ofObject(Object o, Long expirationTime) {
        if (o instanceof Set) {
            Set set = (Set)o;
            String test = set.stream().map(String::valueOf).collect(Collectors.joining(","));
            return new SetVariable(test, expirationTime);
        }
        return new SetVariable(String.valueOf(o), expirationTime);
    }

    public SetVariable(String value) {
        this.build(value);
    }

    public SetVariable(String value, long expirationTime) {
        super(expirationTime);
        this.build(value);
    }

    private void build(String value) {
        Preconditions.checkNotNull((Object)value);
        this.add(value);
    }

    public void add(@NotNull String value) {
        if (value.isEmpty()) {
            return;
        }
        if (value.contains(",")) {
            this.value.addAll(SetVariable.parse(value));
            return;
        }
        this.value.add(value);
    }

    public void remove(@NotNull String value) {
        if (value.contains(",")) {
            SetVariable.parse(value).forEach(this.value::remove);
            return;
        }
        this.value.remove(value);
    }

    public boolean contains(@NotNull String value) {
        if (value.contains(",")) {
            return SetVariable.parse(value).stream().anyMatch(this.value::contains);
        }
        return this.value.contains(value);
    }

    public static List<String> parse(@NotNull String value) {
        return Arrays.asList((String[])Arrays.stream(value.split(",")).filter(s2 -> !s2.isEmpty()).toArray(String[]::new));
    }

    @Override
    public Set<String> get() {
        return this.value;
    }

    @Override
    public Set<String> getValueClone() {
        return Sets.newHashSet(this.value);
    }

    @Override
    public boolean executeAddition(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.add(data.getString(context));
        return true;
    }

    @Override
    public boolean executeSubtraction(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.remove(data.getString(context));
        return true;
    }

    @Override
    public boolean checkEquality(PolymorphicPlaceholder data, PlaceholderContext context) {
        HashSet<String> newSet = new HashSet<String>(SetVariable.parse(data.getString(context)));
        return this.value.equals(newSet);
    }

    @Override
    public boolean checkContainsAll(PolymorphicPlaceholder data, PlaceholderContext context) {
        HashSet<String> newSet = new HashSet<String>(SetVariable.parse(data.getString(context)));
        return this.value.containsAll(newSet);
    }

    @Override
    public String toString() {
        return ListVariable.toString(this.value);
    }

    @Override
    public String formatted() {
        return ListVariable.toString(this.value, ", ");
    }

    public Set<String> getValue() {
        return this.value;
    }

    public void setValue(Set<String> value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetVariable)) {
            return false;
        }
        SetVariable other = (SetVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$value = this.getValue();
        Set<String> other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

