/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.interfaces.ContainingVariable;
import io.lumine.mythic.core.skills.variables.types.ListVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class MapVariable
extends Variable
implements ContainingVariable {
    final Map<String, String> value = new ConcurrentHashMap<String, String>();
    public static final VariableInfo<Map> variableInfo = VariableInfo.builder().clazz(MapVariable.class).type(VariableType.MAP).typeName("Map").valueClass(Map.class).objectConstructor(MapVariable::ofObject).polymorphicConstructor(MapVariable::of).toStringFunction(MapVariable::toString).fromStringFunction(MapVariable::fromString).build();

    public VariableInfo<Map> getVariableInfo() {
        return variableInfo;
    }

    public static MapVariable of(PolymorphicPlaceholder data, PlaceholderContext context, long expirationTime) {
        return new MapVariable(data.getString(context), expirationTime);
    }

    public static String toString(Map<String, String> data) {
        return data.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(";"));
    }

    public static Map<String, String> fromString(String data) {
        return MapVariable.parse(data);
    }

    public static MapVariable ofObject(Object o, Long expirationTime) {
        if (o instanceof Map) {
            Map map = (Map)o;
            return new MapVariable(map, (long)expirationTime);
        }
        return new MapVariable(String.valueOf(o), (long)expirationTime);
    }

    public MapVariable(String value) {
        this.build(value);
    }

    public MapVariable(String value, long expirationTime) {
        super(expirationTime);
        this.build(value);
    }

    public MapVariable(Map<String, String> value, long expirationTime) {
        super(expirationTime);
        Preconditions.checkNotNull(value);
        this.value.putAll(value);
    }

    private void build(String value) {
        Preconditions.checkNotNull((Object)value);
        this.value.putAll(MapVariable.fromString(value));
    }

    public void put(String key, String value) {
        this.value.put(key.trim(), value);
    }

    public void put(String rawData) {
        this.value.putAll(MapVariable.parse(rawData));
    }

    public void remove(String key) {
        String[] split;
        for (String s2 : split = key.split(",")) {
            this.value.remove(s2.trim());
        }
    }

    public String get(String key) {
        return this.value.getOrDefault(key, "UNDEFINED");
    }

    public String get(String key, String defaultValue) {
        return this.value.getOrDefault(key, defaultValue);
    }

    public static String getWithPipeDefault(Map<String, String> map, String key) {
        String[] split;
        if (key.contains("|") && (split = key.split("\\|")).length > 1) {
            key = split[0];
            String defValue = split[1];
            return map.getOrDefault(key, defValue);
        }
        return map.get(key);
    }

    public int size() {
        return this.value.size();
    }

    public boolean containsKey(String key) {
        return this.value.containsKey(key);
    }

    public String getKeys() {
        return ListVariable.toString(this.value.keySet());
    }

    public String getValues() {
        return ListVariable.toString(this.value.values());
    }

    public static Map<String, String> parse(String value) {
        String[] segments;
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String segment : segments = value.split(";")) {
            String[] split = segment.split("=");
            if (split.length != 2) continue;
            ret.put(split[0].trim(), split[1]);
        }
        return ret;
    }

    @Override
    public String toString() {
        return MapVariable.toString(this.value);
    }

    @Override
    public Map<String, String> get() {
        return this.value;
    }

    @Override
    public Map<String, String> getValueClone() {
        return Maps.newHashMap(this.value);
    }

    @Override
    public boolean executeAddition(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.put(data.getString(context));
        return true;
    }

    @Override
    public boolean executeSubtraction(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.remove(data.getString(context));
        return true;
    }

    @Override
    public boolean checkEquality(PolymorphicPlaceholder data, PlaceholderContext context) {
        Map<String, String> newMap = MapVariable.parse(data.getString(context));
        return this.value.equals(newMap);
    }

    @Override
    public boolean checkContainsAll(PolymorphicPlaceholder data, PlaceholderContext context) {
        Map<String, String> newMap = MapVariable.parse(data.getString(context));
        for (String newKey : newMap.keySet()) {
            if (this.value.containsKey(newKey)) continue;
            return false;
        }
        return true;
    }

    public Map<String, String> getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapVariable)) {
            return false;
        }
        MapVariable other = (MapVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$value = this.getValue();
        Map<String, String> other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MapVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

