/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.mobs.GenericCaster;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import io.lumine.mythic.core.drops.DropTable;
import io.lumine.mythic.core.drops.EquipSlot;
import io.lumine.mythic.core.drops.LootBag;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.VariableUtils;
import io.lumine.mythic.core.utils.MythicGson;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemVariable
extends Variable {
    BukkitItemStack value;
    public static final VariableInfo<BukkitItemStack> variableInfo = VariableInfo.builder().clazz(ItemVariable.class).type(VariableType.ITEM).typeName("Item").valueClass(BukkitItemStack.class).objectConstructor(ItemVariable::ofObject).polymorphicConstructor(ItemVariable::of).toStringFunction(ItemVariable::toString).fromStringFunction(ItemVariable::fromString).build();
    private static final Map<String, BiFunction<String, PlaceholderContext, BukkitItemStack>> itemPrefixConversionMap = new ConcurrentHashMap<String, BiFunction<String, PlaceholderContext, BukkitItemStack>>();

    public ItemVariable(BukkitItemStack value, long expirationTime) {
        super(expirationTime);
        this.value = value == null ? BukkitAdapter.adapt(new ItemStack(Material.AIR)) : value;
    }

    public ItemVariable(String value) {
        this.value = Utils.deserializeFromString(value);
    }

    public ItemVariable(String value, long expirationTime) {
        super(expirationTime);
        this.value = Utils.deserializeFromString(value);
    }

    public VariableInfo<BukkitItemStack> getVariableInfo() {
        return variableInfo;
    }

    public static ItemVariable of(PolymorphicPlaceholder data, PlaceholderContext context, long expirationTime) {
        return new ItemVariable(ItemVariable.fromStringWithContext(data.getString(context), context), expirationTime);
    }

    public static String toString(BukkitItemStack value) {
        return Utils.serializeToString(value);
    }

    public static BukkitItemStack fromString(String value) {
        return ItemVariable.fromStringWithContext(value, null);
    }

    public static BukkitItemStack fromStringWithContext(String value, PlaceholderContext context) {
        if (value.startsWith("{")) {
            return Utils.deserializeFromString(value);
        }
        String key = value.trim();
        for (Map.Entry<String, BiFunction<String, PlaceholderContext, BukkitItemStack>> entry : itemPrefixConversionMap.entrySet()) {
            if (!key.startsWith(entry.getKey())) continue;
            return entry.getValue().apply(value.substring(entry.getKey().length() + 1), context);
        }
        return Utils.deserializeFromString(value);
    }

    public static String formatted(BukkitItemStack value) {
        return value.toString();
    }

    public static ItemVariable ofObject(Object o, Long expirationTime) {
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            return new ItemVariable(BukkitAdapter.adapt(stack), (long)expirationTime);
        }
        if (o instanceof BukkitItemStack) {
            BukkitItemStack stack = (BukkitItemStack)o;
            return new ItemVariable(stack, (long)expirationTime);
        }
        if (o instanceof MythicItem) {
            MythicItem mi = (MythicItem)o;
            return new ItemVariable((BukkitItemStack)mi.generateItemStack(1), (long)expirationTime);
        }
        return new ItemVariable(String.valueOf(o), (long)expirationTime);
    }

    @Override
    public BukkitItemStack get() {
        return this.value;
    }

    @Override
    public BukkitItemStack getValueClone() {
        return (BukkitItemStack)this.value.copy();
    }

    @Override
    public boolean executeAddition(PolymorphicPlaceholder data, PlaceholderContext context) {
        return false;
    }

    @Override
    public boolean executeSubtraction(PolymorphicPlaceholder data, PlaceholderContext context) {
        return false;
    }

    @Override
    public boolean checkEquality(PolymorphicPlaceholder data, PlaceholderContext context) {
        String parsed = Utils.serializeToString(this.value);
        return parsed.equals(data.getString(context));
    }

    @Override
    public String toString() {
        return ItemVariable.toString(this.value);
    }

    public static boolean registerItemPrefixConversion(String prefix, BiFunction<String, PlaceholderContext, BukkitItemStack> itemPrefixConversion) {
        return VariableUtils.registerOnMapUtil(itemPrefixConversionMap, prefix, itemPrefixConversion);
    }

    static {
        ItemVariable.registerItemPrefixConversion("mythic", (string, context) -> {
            Optional<MythicItem> maybeItem = VolatileCodeHandler.getPlugin().getItemManager().getItem((String)string);
            if (maybeItem.isPresent()) {
                MythicItem item = maybeItem.get();
                return (BukkitItemStack)item.generateItemStack(1);
            }
            return null;
        });
        ItemVariable.registerItemPrefixConversion("material", (string, context) -> Utils.materialItemStackCache.computeIfAbsent((String)string, key -> BukkitAdapter.adapt(new ItemStack(Material.valueOf((String)key.toUpperCase())))));
        ItemVariable.registerItemPrefixConversion("slot", (string, context) -> {
            ItemStack item;
            if (context == null) {
                throw new NullPointerException("PlaceholderContext cannot be null");
            }
            String parsedSlot = string.trim();
            AbstractEntity entity = null;
            if (context.entity() != null) {
                entity = context.entity();
            } else if (context.meta() != null) {
                if (context.meta().getCaster() != null) {
                    entity = context.meta().getCaster().getEntity();
                } else if (context.meta().getTrigger() != null) {
                    entity = context.meta().getTrigger();
                }
            }
            if (entity == null) {
                throw new NullPointerException("PlaceholderContext is missing entity or trigger");
            }
            Player player = BukkitAdapter.adapt(entity.asPlayer());
            EquipSlot tempSlot = EquipSlot.of(parsedSlot);
            if (tempSlot != EquipSlot.NONE) {
                AbstractItemStack patt0$temp;
                Optional<AbstractItemStack> maybeNamedSlotItemStack = tempSlot.get(entity);
                if (maybeNamedSlotItemStack.isEmpty() || !((patt0$temp = maybeNamedSlotItemStack.get()) instanceof BukkitItemStack)) {
                    return BukkitAdapter.adapt(Utils.defaultMaterial.clone());
                }
                BukkitItemStack bukkitItemStack = (BukkitItemStack)patt0$temp;
                item = bukkitItemStack.getItemStack();
            } else {
                int slot = Integer.parseInt(parsedSlot);
                item = player.getInventory().getItem(slot < 41 ? slot : 0).clone();
            }
            if (item == null) {
                return BukkitAdapter.adapt(Utils.defaultMaterial.clone());
            }
            return BukkitAdapter.adapt(item);
        });
        ItemVariable.registerItemPrefixConversion("drop", (string, context) -> {
            DropTable droptable = new DropTable("ItemVariable", "ItemVariable", List.of(string));
            SkillCaster caster = Objects.requireNonNullElse(context.caster(), new GenericCaster(context.entity()));
            DropMetadataImpl dropMeta = new DropMetadataImpl(caster, context.entity(), context.meta(), null);
            LootBag bag = droptable.generate(dropMeta);
            return (BukkitItemStack)bag.getSingleItem();
        });
    }

    public static class Utils {
        public static ItemStack defaultMaterial = new ItemStack(Material.AIR);
        private static String defaultMaterialSerialized;
        public static final Map<String, BukkitItemStack> materialItemStackCache;
        private static final Type mapType;

        public static String getDefaultMaterialSerialized() {
            if (defaultMaterialSerialized == null) {
                defaultMaterialSerialized = Utils.serializeToString(BukkitAdapter.adapt(defaultMaterial));
            }
            return defaultMaterialSerialized;
        }

        public static String serializeRawToString(ItemStack item) {
            if (item == null) {
                return null;
            }
            Map serializedMap = item.serialize();
            return MythicGson.get().toJson((Object)serializedMap);
        }

        public static String serializeToString(BukkitItemStack item) {
            return Utils.serializeRawToString(item.getItemStack());
        }

        public static ItemStack deserializeRawFromString(String data) {
            if (data == null || data.isEmpty()) {
                return null;
            }
            Map map = (Map)MythicGson.get().fromJson(data, mapType);
            if (map == null) {
                return null;
            }
            return ItemStack.deserialize((Map)map);
        }

        public static BukkitItemStack deserializeFromString(String data) {
            return BukkitAdapter.adapt(Utils.deserializeRawFromString(data));
        }

        static {
            materialItemStackCache = new ConcurrentHashMap<String, BukkitItemStack>();
            mapType = new TypeToken<Map<String, Object>>(){}.getType();
        }
    }

    public static class Serializer
    implements JsonSerializer<ItemVariable>,
    JsonDeserializer<ItemVariable> {
        public JsonElement serialize(ItemVariable src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            JsonElement valueJson = (JsonElement)MythicGson.get().fromJson(Utils.serializeToString(src.value), JsonElement.class);
            obj.add("value", valueJson);
            obj.addProperty("expirationTime", (Number)src.getExpirationTime());
            obj.addProperty("type", src.getTypeName());
            return obj;
        }

        public ItemVariable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            String value = MythicGson.get().toJson(obj.get("value"));
            long expirationTime = obj.has("expirationTime") ? obj.get("expirationTime").getAsLong() : 0L;
            return new ItemVariable(Utils.deserializeFromString(value), expirationTime);
        }
    }
}

