/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.interfaces.NumericVariable;

public class IntegerVariable
extends Variable
implements NumericVariable {
    private int value;
    public static final VariableInfo<Integer> variableInfo = VariableInfo.builder().clazz(IntegerVariable.class).type(VariableType.INTEGER).typeName("Integer").valueClass(Integer.class).objectConstructor(IntegerVariable::ofObject).polymorphicConstructor(IntegerVariable::of).toStringFunction(IntegerVariable::toString).fromStringFunction(IntegerVariable::fromString).build();

    public VariableInfo<Integer> getVariableInfo() {
        return variableInfo;
    }

    public static IntegerVariable of(PolymorphicPlaceholder data, PlaceholderContext context, long expirationTime) {
        return new IntegerVariable(data.getInt(context), expirationTime);
    }

    public static String toString(Integer data) {
        return Integer.toString(data);
    }

    public static Integer fromString(String data) {
        return Integer.parseInt(data);
    }

    public static IntegerVariable ofObject(Object o, Long expirationTime) {
        if (o instanceof Number) {
            Number numberNumber = (Number)o;
            return new IntegerVariable(numberNumber.intValue(), (long)expirationTime);
        }
        return new IntegerVariable(String.valueOf(o), (long)expirationTime);
    }

    public IntegerVariable(int value) {
        this.value = value;
    }

    public IntegerVariable(int value, long expirationTime) {
        super(expirationTime);
        this.value = value;
    }

    public IntegerVariable(String value) {
        this(IntegerVariable.fromString(value));
    }

    public IntegerVariable(String value, long expirationTime) {
        this(IntegerVariable.fromString(value), expirationTime);
    }

    @Override
    public Integer get() {
        return this.value;
    }

    @Override
    public Integer getValueClone() {
        return this.value;
    }

    @Override
    public boolean executeAddition(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.value += data.getInt(context);
        return true;
    }

    @Override
    public boolean executeSubtraction(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.value -= data.getInt(context);
        return true;
    }

    @Override
    public boolean checkEquality(PolymorphicPlaceholder data, PlaceholderContext context) {
        return this.value == data.getInt(context);
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    public void executeMath(String eq) {
        this.value = (int)this.parseMath(eq, this.value);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegerVariable)) {
            return false;
        }
        IntegerVariable other = (IntegerVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getValue() == other.getValue();
    }

    protected boolean canEqual(Object other) {
        return other instanceof IntegerVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getValue();
        return result;
    }
}

