/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.types;

import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableInfo;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.interfaces.NumericVariable;

public class DoubleVariable
extends Variable
implements NumericVariable {
    private double value;
    public static final VariableInfo<Double> variableInfo = VariableInfo.builder().clazz(DoubleVariable.class).type(VariableType.DOUBLE).typeName("Double").valueClass(Double.class).objectConstructor(DoubleVariable::ofObject).polymorphicConstructor(DoubleVariable::of).toStringFunction(DoubleVariable::toString).fromStringFunction(DoubleVariable::fromString).build();

    public VariableInfo<Double> getVariableInfo() {
        return variableInfo;
    }

    public static DoubleVariable of(PolymorphicPlaceholder data, PlaceholderContext context, long expirationTime) {
        return new DoubleVariable(data.getDouble(context), expirationTime);
    }

    public static String toString(Double data) {
        return Double.toString(data);
    }

    public static Double fromString(String data) {
        return Double.parseDouble(data);
    }

    public static DoubleVariable ofObject(Object o, Long expirationTime) {
        if (o instanceof Number) {
            Number numberNumber = (Number)o;
            return new DoubleVariable(numberNumber.doubleValue(), (long)expirationTime);
        }
        return new DoubleVariable(String.valueOf(o), (long)expirationTime);
    }

    public DoubleVariable(double value) {
        this.value = value;
    }

    public DoubleVariable(double value, long expirationTime) {
        super(expirationTime);
        this.value = value;
    }

    public DoubleVariable(String value) {
        this(DoubleVariable.fromString(value));
    }

    public DoubleVariable(String value, long expirationTime) {
        this(DoubleVariable.fromString(value), expirationTime);
    }

    @Override
    public Double get() {
        return this.value;
    }

    @Override
    public Double getValueClone() {
        return this.value;
    }

    @Override
    public boolean executeAddition(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.value += data.getDouble(context);
        return true;
    }

    @Override
    public boolean executeSubtraction(PolymorphicPlaceholder data, PlaceholderContext context) {
        this.value -= data.getDouble(context);
        return true;
    }

    @Override
    public boolean checkEquality(PolymorphicPlaceholder data, PlaceholderContext context) {
        double newValue = data.getDouble(context);
        return this.value == newValue;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    public void executeMath(String eq) {
        this.value = this.parseMath(eq, this.value);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleVariable)) {
            return false;
        }
        DoubleVariable other = (DoubleVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getValue(), other.getValue()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof DoubleVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }
}

