/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables.referencemanagers;

import com.google.common.collect.Lists;
import io.lumine.mythic.core.skills.variables.Variable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class VariableListReferenceManager<T extends Variable> {
    private final List<WeakReference<T>> list = Lists.newCopyOnWriteArrayList();

    public void register(T var) {
        this.list.add(new WeakReference<T>(var));
    }

    public void cleanup() {
        this.list.removeIf(TWeakReference -> TWeakReference.get() == null);
    }

    public List<T> getAllAlive() {
        this.cleanup();
        ArrayList<Variable> alive = new ArrayList<Variable>();
        for (WeakReference<T> ref : this.list) {
            Variable obj = (Variable)ref.get();
            if (obj == null) continue;
            alive.add(obj);
        }
        return alive;
    }

    public void reloadAll() {
    }
}

