/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.variables;

import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.VariableUtils;
import java.util.function.BiFunction;

public record VariableInfo<T>(Class<? extends Variable> clazz, VariableType type, String typeName, Class<T> valueClass, BiFunction<Object, Long, ? extends Variable> objectConstructor, VariableUtils.VariablePolymorphicFactory<? extends Variable> polymorphicConstructor, VariableUtils.VariableToStringFactory<T> toStringFunction, VariableUtils.VariableFromStringFactory<T> fromStringFunction, VariableUtils.VariableToStringFactory<T> formattedFunction) {
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private Class<? extends Variable> clazz;
        private VariableType type;
        private String typeName;
        private Class<T> valueClass;
        private BiFunction<Object, Long, ? extends Variable> objectConstructor;
        private VariableUtils.VariablePolymorphicFactory<? extends Variable> polymorphicConstructor;
        private VariableUtils.VariableToStringFactory<T> toStringFunction;
        private VariableUtils.VariableFromStringFactory<T> fromStringFunction;
        private VariableUtils.VariableToStringFactory<T> formattedFunction;

        public Builder<T> clazz(Class<? extends Variable> clazz) {
            this.clazz = clazz;
            return this;
        }

        public Builder<T> type(VariableType type) {
            this.type = type;
            return this;
        }

        public Builder<T> typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder<T> valueClass(Class<T> valueClass) {
            this.valueClass = valueClass;
            return this;
        }

        public Builder<T> objectConstructor(BiFunction<Object, Long, ? extends Variable> objectConstructor) {
            this.objectConstructor = objectConstructor;
            return this;
        }

        public Builder<T> polymorphicConstructor(VariableUtils.VariablePolymorphicFactory<? extends Variable> polymorphicConstructor) {
            this.polymorphicConstructor = polymorphicConstructor;
            return this;
        }

        public Builder<T> toStringFunction(VariableUtils.VariableToStringFactory<T> toStringFunction) {
            this.toStringFunction = toStringFunction;
            return this;
        }

        public Builder<T> fromStringFunction(VariableUtils.VariableFromStringFactory<T> fromStringFunction) {
            this.fromStringFunction = fromStringFunction;
            return this;
        }

        public Builder<T> formattedFunction(VariableUtils.VariableToStringFactory<T> formattedFunction) {
            this.formattedFunction = formattedFunction;
            return this;
        }

        public VariableInfo<T> build() {
            VariableUtils.VariableToStringFactory<T> formatted;
            VariableUtils.VariableToStringFactory<T> variableToStringFactory = formatted = this.formattedFunction != null ? this.formattedFunction : this.toStringFunction;
            if (this.clazz == null) {
                throw new IllegalArgumentException("Variable class cannot be null");
            }
            if (this.type == null) {
                throw new IllegalArgumentException("Variable type cannot be null");
            }
            if (this.typeName == null || this.typeName.isEmpty()) {
                throw new IllegalArgumentException("Variable type name cannot be null or empty");
            }
            return new VariableInfo<T>(this.clazz, this.type, this.typeName, this.valueClass, this.objectConstructor, this.polymorphicConstructor, this.toStringFunction, this.fromStringFunction, formatted);
        }
    }
}

