/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;

@MythicTargeter(author="Phil", name="UniqueIdentifier", aliases={"uuid"}, description="Targets a specific entity with that uuid")
public class UniqueIdentifierTargeter
extends IEntitySelector {
    private final PlaceholderString uuid;

    public UniqueIdentifierTargeter(SkillExecutor manager, MythicLineConfig config) {
        super(manager, config);
        this.uuid = config.getPlaceholderString(new String[]{"uuid", "u"}, "0", new String[0]);
        this.targetAll = true;
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        HashSet targets = Sets.newHashSet();
        AbstractEntity entity = this.getPlugin().getBootstrap().getEntity(UUID.fromString(this.uuid.get(data)));
        if (entity != null) {
            targets.add(entity);
        }
        return targets;
    }
}

