/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.core.mobs.MobExecutor;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.ILocationSelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;

@MythicTargeter(author="Phil", name="randomLocationsNearOrigin", aliases={"RLO", "randomLocationsOrigin", "RLNO"}, description="Targets random locations near the caster")
public class RandomLocationsNearOriginTargeter
extends ILocationSelector {
    private PlaceholderInt amount;
    private int maxRadius;
    private int minRadius;
    private int minRadiusSq;
    private int spacing;
    private int spacingSq;
    private boolean onSurface;

    public RandomLocationsNearOriginTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.amount = mlc.getPlaceholderInteger(new String[]{"amount", "a"}, 5, new String[0]);
        this.maxRadius = mlc.getInteger(new String[]{"radius", "r", "maxradius", "maxr"}, 5);
        this.minRadius = mlc.getInteger(new String[]{"minradius", "minr"}, 0);
        this.spacing = mlc.getInteger(new String[]{"spacing", "s"}, 0);
        this.onSurface = mlc.getBoolean(new String[]{"onsurface", "onsurf", "os"}, false);
        this.minRadiusSq = this.minRadius * this.minRadius;
        this.spacingSq = this.spacing * this.spacing;
    }

    @Override
    public Collection<AbstractLocation> getLocations(SkillMetadata data) {
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        int amount = this.amount.get(data);
        int amountSq = amount * amount;
        AbstractLocation origin = data.getOrigin();
        int i = 0;
        int j = 0;
        while (i < amount && j < amountSq) {
            ++j;
            this.getPlugin().getMobManager();
            AbstractLocation l = MobExecutor.findSafeSpawnLocation(origin, this.maxRadius, 0.0, 1, true, this.onSurface);
            if (this.minRadius > 0 && l.distanceSquared(origin) < (double)this.minRadiusSq) continue;
            if (this.spacing > 0) {
                boolean bad = false;
                for (AbstractLocation l2 : targets) {
                    if (!(l.distanceSquared(l2) < (double)this.spacingSq)) continue;
                    bad = true;
                    break;
                }
                if (bad) continue;
            }
            targets.add(this.mutate(data, l));
            ++i;
        }
        return targets;
    }
}

