/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Collection;

@MythicTargeter(author="Ashijin", name="playersNearTargetLocations", aliases={"playersNearTargetLocation", "PNTL"}, description="Targets all players near the inherited locations")
public class PlayersNearTargetLocationsTargeter
extends IEntitySelector {
    double radius;

    public PlayersNearTargetLocationsTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.radius = mlc.getDouble(new String[]{"radius", "r"}, 5.0);
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        ArrayList targets = Lists.newArrayList();
        Collection<AbstractLocation> baseLocations = this.getMetaLocations(data);
        double range = Math.pow(this.radius, 2.0);
        block0: for (AbstractEntity abstractEntity : data.getCaster().getEntity().getWorld().getPlayers()) {
            if (!data.getCaster().getLocation().getWorld().equals(abstractEntity.getWorld()) || abstractEntity.getUniqueId().equals(data.getCaster().getEntity().getUniqueId())) continue;
            for (AbstractLocation l : baseLocations) {
                if (!(this.distanceSquared(l, abstractEntity) < range)) continue;
                targets.add(abstractEntity);
                continue block0;
            }
        }
        return targets;
    }
}

