/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

@MythicTargeter(author="Ashijin", name="MobsInRadius", aliases={"MOBS", "MIR"}, description="Targets all MythicMobs or vanilla overrides of the given type(s) in a radius around the caster")
public class MobsInRadiusTargeter
extends IEntitySelector {
    private PlaceholderDouble radius;
    private HashSet<MythicMob> mmTypes = new HashSet();
    private HashSet<BukkitEntityType> meTypes = new HashSet();
    private boolean checkIfTemplate;

    public MobsInRadiusTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.radius = mlc.getPlaceholderDouble(new String[]{"radius", "r"}, 5.0, new String[0]);
        this.checkIfTemplate = mlc.getBoolean(new String[]{"checkIfTemplate", "cit"}, false);
        String types = mlc.getString(new String[]{"types", "type", "t"}, "", new String[0]);
        List<String> ss = Arrays.stream(types.split(",")).toList();
        MobsInRadiusTargeter THIS = this;
        this.getPlugin().getSkillManager().queueSecondPass(() -> {
            for (String s2 : ss) {
                MythicMob mm4 = MythicBukkit.inst().getMobManager().getMythicMob(s2).orElse(null);
                if (mm4 != null) {
                    THIS.mmTypes.add(mm4);
                    continue;
                }
                BukkitEntityType me = BukkitEntityType.getMythicEntity(s2);
                if (me != null) {
                    THIS.meTypes.add(me);
                    continue;
                }
                MythicLogger.errorTargeterConfig(this, mlc, "The 'type' attribute must be a valid MythicMob or MythicEntity type.");
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "@MIR targeter loaded targeting " + (THIS.meTypes.size() + THIS.mmTypes.size()) + " types", new Object[0]);
        });
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        AbstractEntity caster = am.getEntity();
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        double parsedRadius = this.radius.get(data);
        double radiusSq = Math.pow(parsedRadius, 2.0);
        List<String> typesIds = this.mmTypes.stream().map(MythicMob::getInternalName).toList();
        if (parsedRadius > 128.0) {
            ArrayList toCheck = Lists.newArrayList(am.getEntity().getWorld().getLivingEntities());
            block0: for (AbstractEntity p : toCheck) {
                if (p.getUniqueId().equals(am.getEntity().getUniqueId()) || !p.getWorld().equals(am.getEntity().getWorld()) || !(this.distanceSquared(am.getEntity().getLocation(), p) <= radiusSq)) continue;
                ActiveMob amx = this.getPlugin().getMobManager().getMythicMobInstance(p);
                if (amx != null) {
                    if (this.checkIfTemplate && amx.getType().getConfig().isSet("TemplateParents")) {
                        List<String> mobTemplates = amx.getType().getConfig().getStringList("TemplateParents");
                        if (mobTemplates.stream().anyMatch(typesIds::contains)) {
                            targets.add(p);
                        }
                    }
                    if (!this.mmTypes.contains(amx.getType())) continue;
                    targets.add(p);
                    continue;
                }
                for (BukkitEntityType me : this.meTypes) {
                    if (!me.compare(p.getBukkitEntity())) continue;
                    targets.add(p);
                    continue block0;
                }
            }
        } else {
            targets.addAll(this.getPlugin().getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(am.getLocation(), parsedRadius, entity -> {
                if (entity.getUniqueId().equals(am.getEntity().getUniqueId())) {
                    return false;
                }
                if (this.distanceSquared(caster.getLocation(), (AbstractEntity)entity) > radiusSq) {
                    return false;
                }
                if (!this.getPlugin().getMobManager().isLoadedMob((AbstractEntity)entity)) {
                    return false;
                }
                ActiveMob amCompare = this.getPlugin().getMobManager().getMythicMobInstance((AbstractEntity)entity);
                if (amCompare != null) {
                    if (this.checkIfTemplate && amCompare.getType().getConfig().isSet("TemplateParents")) {
                        List<String> mobTemplates = amCompare.getType().getConfig().getStringList("TemplateParents");
                        if (mobTemplates.stream().anyMatch(typesIds::contains)) {
                            return true;
                        }
                    }
                    if (this.mmTypes.contains(amCompare.getType())) {
                        return true;
                    }
                } else {
                    for (BukkitEntityType me : this.meTypes) {
                        if (!me.compare(entity.getBukkitEntity())) continue;
                        return true;
                    }
                }
                return false;
            }));
        }
        return targets;
    }
}

