/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.targeters;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.targeters.IEntitySelector;
import io.lumine.mythic.core.utils.annotations.MythicTargeter;
import java.util.Collection;
import java.util.HashSet;

@MythicTargeter(author="Ashijin", name="livingInLine", aliases={"entitiesInLine", "livingEntitiesInLine", "LEIL", "EIL"}, description="Targets random points in a cone shape")
public class LivingInLineTargeter
extends IEntitySelector {
    protected float radius = 1.0f;
    protected float radiusSq;
    protected boolean fromOrigin = false;

    public LivingInLineTargeter(SkillExecutor manager, MythicLineConfig mlc) {
        super(manager, mlc);
        this.radius = mlc.getFloat(new String[]{"radius", "r"}, this.radius);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromorigin", "fo"}, false);
        this.radiusSq = this.radius * this.radius;
    }

    @Override
    public Collection<AbstractEntity> getEntities(SkillMetadata data) {
        HashSet<AbstractEntity> targets = new HashSet<AbstractEntity>();
        AbstractLocation sl = this.fromOrigin ? data.getOrigin().clone() : data.getCaster().getLocation();
        double range = 1.0;
        if (data.getLocationTargets() != null && data.getLocationTargets().size() > 0) {
            for (AbstractLocation abstractLocation : data.getLocationTargets()) {
                d = abstractLocation.distanceSquared(sl);
                if (!(d > range)) continue;
                range = d;
            }
        } else if (data.getEntityTargets() != null && data.getEntityTargets().size() > 0) {
            for (AbstractEntity abstractEntity : data.getEntityTargets()) {
                d = abstractEntity.getLocation().distanceSquared(sl);
                if (!(d > range)) continue;
                range = d;
            }
        } else {
            return targets;
        }
        SkillCaster am = data.getCaster();
        HashSet<AbstractEntity> hashSet = new HashSet<AbstractEntity>();
        for (AbstractEntity p : am.getEntity().getWorld().getLivingEntities()) {
            if (!am.getLocation().getWorld().equals(p.getWorld()) || p.getUniqueId().equals(am.getEntity().getUniqueId()) || !(this.distanceSquared(am.getEntity().getLocation(), p) <= range)) continue;
            hashSet.add(p);
        }
        if (data.getLocationTargets() != null && data.getLocationTargets().size() > 0) {
            data.getLocationTargets().forEach(l -> {
                int c = (int)Math.ceil(sl.distance((AbstractLocation)l) / (double)this.radius) - 1;
                if (c <= 0) {
                    return;
                }
                AbstractVector v = l.toVector().subtract(sl.toVector()).normalize().multiply(this.radius);
                AbstractLocation l2 = sl.clone();
                for (int i = 0; i < c; ++i) {
                    l2.add(v);
                    for (AbstractEntity e : possible) {
                        if (!(this.distanceSquared(l2, e) <= (double)this.radiusSq)) continue;
                        targets.add(e);
                    }
                }
            });
        } else if (data.getEntityTargets() != null && data.getEntityTargets().size() > 0) {
            data.getEntityTargets().forEach(ee -> {
                AbstractLocation l = ee.getLocation();
                int c = (int)Math.ceil(sl.distance(l) / (double)this.radius) - 1;
                if (c <= 0) {
                    return;
                }
                AbstractVector v = l.toVector().subtract(sl.toVector()).normalize().multiply(this.radius);
                AbstractLocation l2 = sl.clone();
                for (int i = 0; i < c; ++i) {
                    l2.add(v);
                    for (AbstractEntity e : possible) {
                        if (!(this.distanceSquared(l2, e) <= (double)this.radiusSq)) continue;
                        targets.add(e);
                    }
                }
            });
        }
        return targets;
    }
}

