/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.stats.types;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.events.MythicStatChangeEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.types.IntProp;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.skills.stats.StatExecutor;
import io.lumine.mythic.core.skills.stats.StatType;
import java.util.Map;
import org.bukkit.event.player.PlayerQuitEvent;

public class HealthRegenStat
extends StatType {
    private static final IntProp FREQUENCY = Property.Int(Scope.STATS, "Frequency", 60);
    private Map<AbstractPlayer, Double> toHeal = Maps.newConcurrentMap();

    public HealthRegenStat(String key) {
        super(key);
    }

    @Override
    public void initialize(StatExecutor manager) {
        super.initialize(manager);
        int frequency = (Integer)FREQUENCY.fget(this.getScope(), this);
        Events.subscribe(MythicStatChangeEvent.class).filter(event -> event.getStat() == this).filter(event -> event.getCaster().getEntity().isPlayer()).handler(event -> {
            SkillCaster caster = event.getCaster();
            double value = event.getNewValue();
            if (value == 0.0) {
                this.toHeal.remove(event.getCaster().getEntity().asPlayer());
            } else {
                this.toHeal.put(event.getCaster().getEntity().asPlayer(), value);
            }
        }).bindWith(this);
        Events.subscribe(PlayerQuitEvent.class).handler(event -> this.toHeal.remove(BukkitAdapter.adapt(event.getPlayer()))).bindWith(this);
        Schedulers.sync().runRepeating(this::doHealing, (long)frequency, (long)frequency).bindWith(this);
    }

    @Override
    public boolean isApplicable(AbstractEntity entity) {
        return entity.isPlayer();
    }

    private void doHealing() {
        for (Map.Entry<AbstractPlayer, Double> entry : this.toHeal.entrySet()) {
            double max;
            double health;
            AbstractPlayer player = entry.getKey();
            Double amount = entry.getValue();
            if (player.isDead() || (health = player.getHealth()) == (max = player.getMaxHealth())) continue;
            double newHealth = health + amount;
            player.setHealth(Math.min(newHealth, max));
        }
    }
}

