/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.stats.types;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.stats.StatSnapshot;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.skills.stats.StatExecutor;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythic.core.skills.stats.TriggerModifyingStat;
import io.lumine.mythic.core.skills.triggers.SkillTriggerMetadata;
import io.lumine.mythic.core.skills.triggers.meta.DamagedMetadata;
import io.lumine.mythic.core.skills.triggers.meta.EntityAttackMetadata;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public class DamageModifierStat
extends StatType
implements TriggerModifyingStat {
    private static final StringProp TYPE = Property.String(Scope.STATS, "DamageType", null);
    private static final StringProp FORMULA = Property.String(Scope.STATS, "DamageFormula", null);
    private static final StringListProp CONDITIONS = Property.StringList(Scope.STATS, "Conditions");
    private static final StringListProp PARENTS = Property.StringList(Scope.STATS, "ParentStats");
    private static final StringListProp TRIGGER_STATS = Property.StringList(Scope.STATS, "TriggerStats");
    private String damageType;
    private boolean allDamage = false;
    private Expression expression;
    private List<SkillCondition> conditions = Lists.newArrayList();
    private final Collection<StatType> parentStats = Sets.newConcurrentHashSet();
    private final Map<StatType, String> triggerStats = Maps.newConcurrentMap();

    public DamageModifierStat(Object scope, String key) {
        super(scope, key);
    }

    @Override
    public void initialize(StatExecutor manager) {
        super.initialize(manager);
        this.damageType = (String)TYPE.fget(this.getScope(), this);
        if (this.damageType != null && this.damageType.equalsIgnoreCase("ALL")) {
            this.allDamage = true;
        }
        for (Object key : (List)PARENTS.get(this)) {
            Optional<StatType> maybeStat = this.getManager().getStat((String)key);
            if (maybeStat.isEmpty()) {
                MythicLogger.error("Invalid parent stat {0}", key);
                return;
            }
            this.parentStats.add(maybeStat.get());
        }
        for (Object key : (List)TRIGGER_STATS.get(this)) {
            try {
                String[] split = ((String)key).split(" ");
                String statKey = split[0];
                String formulaKey = split[1];
                Optional<StatType> maybeStat = this.getManager().getStat(statKey);
                if (maybeStat.isEmpty()) {
                    MythicLogger.error("Invalid trigger stat {0}", key);
                    return;
                }
                this.triggerStats.put(maybeStat.get(), formulaKey);
            }
            catch (Throwable ex) {
                MythicLogger.error("Invalid Trigger Stat {0}", key);
            }
        }
        List conditions = (List)CONDITIONS.fget(this.getScope(), this);
        for (String cond : conditions) {
            SkillCondition c = MythicBukkit.inst().getSkillManager().getCondition(cond);
            if (c instanceof InvalidCondition) continue;
            this.conditions.add(c);
        }
        String formula = (String)FORMULA.fget(this.getScope(), this);
        try {
            ExpressionBuilder builder = new ExpressionBuilder(formula).operator(Operators.operators).functions(Functions.functions).variables("d", "v");
            for (StatType parentStat : this.parentStats) {
                builder.variable(parentStat.getFormulaKey());
            }
            for (String stat : this.triggerStats.values()) {
                builder.variable(stat);
            }
            this.expression = builder.build();
        }
        catch (Exception ex) {
            MythicLogger.error("X Invalid DamageModifier formula defined: " + formula);
            ex.printStackTrace();
            this.expression = new ExpressionBuilder("0").build();
            return;
        }
    }

    @Override
    public void processTrigger(SkillMetadata skillMetadata, SkillTriggerMetadata triggerMetadata, StatSnapshot statRegistry, double value) {
        if (!this.triggerStats.isEmpty() && skillMetadata.getTrigger() == null) {
            return;
        }
        if (triggerMetadata instanceof EntityAttackMetadata) {
            EntityAttackMetadata attackMetadata = (EntityAttackMetadata)triggerMetadata;
            for (SkillCondition condition : this.conditions) {
                if (condition.evaluateCaster(skillMetadata)) continue;
                return;
            }
            if (this.damageType == null) {
                double damage = attackMetadata.getDamage();
                Expression expression = this.expression;
                for (StatType statType : this.parentStats) {
                    expression.setVariable(statType.getFormulaKey(), statRegistry.get(statType));
                }
                if (!this.triggerStats.isEmpty()) {
                    StatRegistry statRegistry2 = this.getStatRegistry(skillMetadata.getTrigger());
                    for (Map.Entry<StatType, String> entry : this.triggerStats.entrySet()) {
                        expression.setVariable(entry.getValue(), statRegistry2.get(entry.getKey()));
                    }
                }
                double d2 = expression.setVariable("d", damage).setVariable("v", value).evaluate();
                attackMetadata.setDamage(d2);
            } else if (this.allDamage) {
                double damage = attackMetadata.getDamageModifier();
                Expression expression = this.expression;
                for (StatType statType : this.parentStats) {
                    expression.setVariable(statType.getFormulaKey(), statRegistry.get(statType));
                }
                if (!this.triggerStats.isEmpty()) {
                    StatRegistry statRegistry3 = this.getStatRegistry(skillMetadata.getTrigger());
                    for (Map.Entry<StatType, String> entry : this.triggerStats.entrySet()) {
                        expression.setVariable(entry.getValue(), statRegistry3.get(entry.getKey()));
                    }
                }
                double d3 = expression.setVariable("d", damage).setVariable("v", value).evaluate();
                attackMetadata.setDamageModifier(d3);
            } else {
                if (!attackMetadata.getBonusDamage().containsKey(this.damageType)) {
                    return;
                }
                Double damage = attackMetadata.getBonusDamage().computeIfAbsent(this.damageType, d -> value);
                Expression expression = this.expression;
                for (StatType statType : this.parentStats) {
                    expression.setVariable(statType.getFormulaKey(), statRegistry.get(statType));
                }
                if (!this.triggerStats.isEmpty()) {
                    StatRegistry triggerStatRegistry = this.getStatRegistry(skillMetadata.getTrigger());
                    for (Map.Entry<StatType, String> entry : this.triggerStats.entrySet()) {
                        expression.setVariable(entry.getValue(), triggerStatRegistry.get(entry.getKey()));
                    }
                }
                double newDamage = expression.setVariable("d", damage).setVariable("v", value).evaluate();
                attackMetadata.getBonusDamage().put(this.damageType, newDamage);
            }
        } else if (triggerMetadata instanceof DamagedMetadata) {
            DamagedMetadata damagedMetadata = (DamagedMetadata)triggerMetadata;
            for (SkillCondition condition : this.conditions) {
                if (condition.evaluateCaster(skillMetadata)) continue;
                return;
            }
            if (this.damageType == null) {
                double damage = damagedMetadata.getDamage();
                Expression expression = this.expression;
                for (StatType statType : this.parentStats) {
                    expression.setVariable(statType.getFormulaKey(), statRegistry.get(statType));
                }
                if (!this.triggerStats.isEmpty()) {
                    StatRegistry statRegistry4 = this.getStatRegistry(skillMetadata.getTrigger());
                    for (Map.Entry<StatType, String> entry : this.triggerStats.entrySet()) {
                        expression.setVariable(entry.getValue(), statRegistry4.get(entry.getKey()));
                    }
                }
                double d4 = expression.setVariable("d", damage).setVariable("v", value).evaluate();
                damagedMetadata.setDamage(d4);
            } else {
                if (!damagedMetadata.getBonusDamage().containsKey(this.damageType)) {
                    return;
                }
                Double damage = damagedMetadata.getBonusDamage().computeIfAbsent(this.damageType, d -> value);
                Expression expression = this.expression;
                for (StatType statType : this.parentStats) {
                    expression.setVariable(statType.getFormulaKey(), statRegistry.get(statType));
                }
                if (!this.triggerStats.isEmpty()) {
                    StatRegistry triggerStatRegistry = this.getStatRegistry(skillMetadata.getTrigger());
                    for (Map.Entry<StatType, String> entry : this.triggerStats.entrySet()) {
                        expression.setVariable(entry.getValue(), triggerStatRegistry.get(entry.getKey()));
                    }
                }
                double newDamage = expression.setVariable("d", damage).setVariable("v", value).evaluate();
                damagedMetadata.getBonusDamage().put(this.damageType, newDamage);
            }
        }
    }
}

