/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.projectiles;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletableTracker;
import io.lumine.mythic.core.utils.annotations.MythicField;

public abstract class ProjectileBullet {
    private final SkillMechanic projectileMechanic;
    private final MythicLineConfig config;
    @MythicField(name="bulletForwardOffset", aliases={"bfoffset", "bfo"}, description="The forward offset for the bullet", defValue="1.35")
    protected double bulletForwardOffset;
    @MythicField(name="bulletYOffset", aliases={"byoffset", "byo"}, description="The Y offset for the bullet", defValue="1.35")
    protected double bulletYOffset;

    public ProjectileBullet(ProjectileBulletType type, SkillMechanic projectile, MythicLineConfig config) {
        this.projectileMechanic = projectile;
        this.config = config;
        this.bulletForwardOffset = config.getDouble(new String[]{"bulletforwardoffset", "bulletfo", "bulletoffset", "bfo"}, 1.8);
        this.bulletYOffset = config.getDouble(new String[]{"bulletyoffset", "byoffset", "byo"}, 0.0);
    }

    public MythicBukkit getPlugin() {
        if (this.projectileMechanic == null) {
            return MythicBukkit.inst();
        }
        return this.projectileMechanic.getPlugin();
    }

    public abstract BulletTracker create(ProjectileBulletableTracker var1, AbstractEntity var2);

    public abstract boolean isVirtual();

    public SkillMechanic getProjectileMechanic() {
        return this.projectileMechanic;
    }

    public MythicLineConfig getConfig() {
        return this.config;
    }

    public double getBulletForwardOffset() {
        return this.bulletForwardOffset;
    }

    public double getBulletYOffset() {
        return this.bulletYOffset;
    }

    public abstract class BulletTracker {
        private final ProjectileBulletableTracker projectile;
        private final AbstractEntity target;

        public boolean isVirtual() {
            return ProjectileBullet.this.isVirtual();
        }

        public abstract void spawn(AbstractLocation var1);

        public abstract void tick(AbstractLocation var1);

        public abstract void despawn();

        public BulletTracker(ProjectileBulletableTracker projectile, AbstractEntity target) {
            this.projectile = projectile;
            this.target = target;
        }

        public ProjectileBulletableTracker getProjectile() {
            return this.projectile;
        }

        public AbstractEntity getTarget() {
            return this.target;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BulletTracker)) {
                return false;
            }
            BulletTracker other = (BulletTracker)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ProjectileBulletableTracker this$projectile = this.getProjectile();
            ProjectileBulletableTracker other$projectile = other.getProjectile();
            if (this$projectile == null ? other$projectile != null : !this$projectile.equals(other$projectile)) {
                return false;
            }
            AbstractEntity this$target = this.getTarget();
            AbstractEntity other$target = other.getTarget();
            return !(this$target == null ? other$target != null : !this$target.equals(other$target));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BulletTracker;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ProjectileBulletableTracker $projectile = this.getProjectile();
            result = result * 59 + ($projectile == null ? 43 : $projectile.hashCode());
            AbstractEntity $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            return result;
        }

        public String toString() {
            return "ProjectileBullet.BulletTracker(projectile=" + String.valueOf(this.getProjectile()) + ", target=" + String.valueOf(this.getTarget()) + ")";
        }
    }
}

