/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.parsers;

import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.skills.placeholders.IPlaceholder;
import io.lumine.mythic.api.skills.placeholders.PlaceholderBoolean;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderLong;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.skills.placeholders.PlaceholderTime;
import io.lumine.mythic.api.skills.placeholders.PlaceholderVector;
import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderBooleanImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderDoubleImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderFloatImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderIntImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderLongImpl;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderVectorImpl;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.types.ListVariable;
import io.lumine.mythic.core.skills.variables.types.MapVariable;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PolymorphicPlaceholderImpl
implements PolymorphicPlaceholder {
    protected final String value;
    private static final PlaceholderGetter<PlaceholderInt> intGetter;
    private static final PlaceholderGetter<PlaceholderFloat> floatGetter;
    private static final PlaceholderGetter<PlaceholderLong> longGetter;
    private static final PlaceholderGetter<PlaceholderDouble> doubleGetter;
    private static final PlaceholderGetter<PlaceholderBoolean> booleanGetter;
    private static final PlaceholderGetter<PlaceholderVector> vectorGetter;
    private final Map<VariableType, IPlaceholder> cache = new HashMap<VariableType, IPlaceholder>();
    private static final Map<VariableType, PlaceholderGetter<IPlaceholder>> resolutionMap;

    public PolymorphicPlaceholderImpl(String input) {
        this.value = input;
    }

    @Override
    public PolymorphicPlaceholderImpl cache(VariableType type) {
        PlaceholderGetter<IPlaceholder> resolver = resolutionMap.get((Object)type);
        if (resolver == null) {
            return this;
        }
        this.cache.put(type, resolver.get(this.value));
        return this;
    }

    @Override
    public String originalValue() {
        return this.value;
    }

    @Override
    public String getString(PlaceholderContext context) {
        return ((PlaceholderString)this.cache.computeIfAbsent(VariableType.STRING, t2 -> PlaceholderString.of(this.value))).get(context);
    }

    @Override
    public int getInt(PlaceholderContext context) {
        return ((PlaceholderInt)this.cache.computeIfAbsent(VariableType.INTEGER, t2 -> intGetter.get(this.value))).get(context);
    }

    @Override
    public float getFloat(PlaceholderContext context) {
        return ((PlaceholderFloat)this.cache.computeIfAbsent(VariableType.FLOAT, t2 -> floatGetter.get(this.value))).get(context);
    }

    @Override
    public double getDouble(PlaceholderContext context) {
        return ((PlaceholderDouble)this.cache.computeIfAbsent(VariableType.DOUBLE, t2 -> doubleGetter.get(this.value))).get(context);
    }

    @Override
    public Long getLong(PlaceholderContext context) {
        return ((PlaceholderLong)this.cache.computeIfAbsent(VariableType.LONG, t2 -> longGetter.get(this.value))).get(context);
    }

    @Override
    public boolean getBoolean(PlaceholderContext context) {
        return ((PlaceholderBoolean)this.cache.computeIfAbsent(VariableType.BOOLEAN, t2 -> booleanGetter.get(this.value))).get(context);
    }

    @Override
    public List<String> getList(PlaceholderContext context) {
        return ListVariable.fromString(((PlaceholderString)this.cache.computeIfAbsent(VariableType.STRING, t2 -> PlaceholderString.of(this.value))).get(context));
    }

    @Override
    public Map<String, String> getMap(PlaceholderContext context) {
        return MapVariable.fromString(((PlaceholderString)this.cache.computeIfAbsent(VariableType.STRING, t2 -> PlaceholderString.of(this.value))).get(context));
    }

    @Override
    public AbstractVector getVector(PlaceholderContext context) {
        return ((PlaceholderVector)this.cache.computeIfAbsent(VariableType.VECTOR, t2 -> vectorGetter.get(this.value))).get(context);
    }

    @Override
    public Instant getTime(PlaceholderContext context) {
        return (Instant)((PlaceholderTime)this.cache.computeIfAbsent(VariableType.TIME, t2 -> PlaceholderTime.of(this.value))).get(context);
    }

    static {
        if (MythicBukkit.isVolatile()) {
            intGetter = PlaceholderInt::of;
            floatGetter = PlaceholderFloat::of;
            doubleGetter = PlaceholderDouble::of;
            longGetter = PlaceholderLong::of;
            booleanGetter = PlaceholderBoolean::of;
            vectorGetter = PlaceholderVector::of;
        } else {
            intGetter = PlaceholderIntImpl::new;
            floatGetter = PlaceholderFloatImpl::new;
            longGetter = PlaceholderLongImpl::new;
            doubleGetter = PlaceholderDoubleImpl::new;
            booleanGetter = PlaceholderBooleanImpl::new;
            vectorGetter = PlaceholderVectorImpl::new;
        }
        resolutionMap = new HashMap<VariableType, PlaceholderGetter<IPlaceholder>>();
        resolutionMap.put(VariableType.INTEGER, intGetter::get);
        resolutionMap.put(VariableType.FLOAT, floatGetter::get);
        resolutionMap.put(VariableType.DOUBLE, doubleGetter::get);
        resolutionMap.put(VariableType.LONG, longGetter::get);
        resolutionMap.put(VariableType.BOOLEAN, booleanGetter::get);
        resolutionMap.put(VariableType.VECTOR, vectorGetter::get);
        resolutionMap.put(VariableType.STRING, PlaceholderString::of);
        resolutionMap.put(VariableType.TIME, PlaceholderTime::of);
    }

    @FunctionalInterface
    private static interface PlaceholderGetter<T> {
        public T get(String var1);
    }
}

