/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.parsers;

import io.lumine.mythic.api.skills.placeholders.PlaceholderLong;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.RandomInt;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.parsers.PlaceholderNumber;
import io.lumine.mythic.core.skills.placeholders.parsers.RandomLong;
import io.lumine.mythic.core.skills.placeholders.parsers.StaticLong;
import java.util.Objects;

public class PlaceholderLongImpl
extends PlaceholderNumber<Long>
implements PlaceholderLong {
    public static PlaceholderLongImpl of(String string) {
        try {
            if (string == null) {
                return null;
            }
            if (RandomInt.matchesRange(string)) {
                return new RandomLong(string);
            }
            if (string.matches("-?\\d+")) {
                return new StaticLong(string);
            }
            if (!MythicBukkit.isVolatile()) {
                MythicLogger.error("Failed to parse Placeholder '" + string + "': Math and variables in numeric values require premium! Consider getting MythicMobs Premium at www.mythiccraft.io");
                return new StaticLong("1");
            }
            return new PlaceholderLongImpl(string);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MythicLogger.error("Failed to parse Placeholder '" + string + "': invalid syntax.");
            return new StaticLong("1");
        }
    }

    PlaceholderLongImpl(String data) {
        super(data);
    }

    @Override
    public boolean isStaticallyEqualTo(Long value) {
        return this.isStatic() && Objects.equals(this.get(), value);
    }

    @Override
    protected Long convertNumberToSelfType(double number) {
        return (long)number;
    }

    @Override
    protected Long convertStringToSelfType(String string) {
        return Long.parseLong(string);
    }

    @Override
    protected Long getDefaultValue() {
        return 1L;
    }
}

