/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.parsers;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.placeholders.PlaceholderAngle;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.Angle;
import io.lumine.mythic.bukkit.utils.numbers.AngleUnit;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.GenericPlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.PlaceholderParser;
import io.lumine.mythic.core.skills.placeholders.parsers.RandomAngle;
import io.lumine.mythic.core.skills.placeholders.parsers.StaticAngle;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import java.util.regex.Pattern;
import net.objecthunter.exp4j.ExpressionBuilder;

public class PlaceholderAngleImpl
extends PlaceholderParser
implements PlaceholderAngle {
    private static final Pattern FIRST_UNIT = Pattern.compile("(-?\\d+(?:\\.\\d+)?)([a-zA-Z\u00b0]+)");
    private static final Pattern NUMBER_LITERAL = Pattern.compile("(?<![\\w.])(-?\\d+(?:\\.\\d+)?)(?![\\w.])");
    private AngleUnit defaultUnit = AngleUnit.DEGREES;

    public PlaceholderAngleImpl() {
    }

    public PlaceholderAngleImpl(String string, AngleUnit defaultUnit) {
        super(string);
        this.defaultUnit = defaultUnit;
        if (string != null && (string.startsWith("=") || string.contains("(") && string.contains(")"))) {
            this.doMath = true;
        }
    }

    @Override
    public Angle get() {
        String string = this.strValue;
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    @Override
    public Angle get(PlaceholderMeta meta) {
        return this.get(meta, meta == null ? null : meta.getTrigger());
    }

    @Override
    public Angle get(AbstractEntity entity) {
        return this.get(null, entity);
    }

    @Override
    public Angle get(PlaceholderMeta meta, AbstractEntity entity) {
        String string = this.parse(meta, entity);
        if (this.papi) {
            string = entity != null && entity.isPlayer() ? MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string, entity.asPlayer()) : MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    public Angle get(PlaceholderMeta meta, AbstractItemStack itemStack) {
        String string = this.parse(meta, itemStack);
        if (this.papi) {
            string = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().get().parse(string);
        }
        return this.handleParsing(string);
    }

    private Angle handleParsing(String input) {
        double numeric;
        if (input == null || input.isBlank()) {
            MythicLogger.error("Empty angle string: " + this.strValue);
            return new Angle(0.0, this.defaultUnit);
        }
        String s2 = input.trim();
        AngleUnit unit = this.defaultUnit;
        block2: for (AngleUnit u : AngleUnit.values()) {
            for (String suf : u.suffixes()) {
                if (!s2.toLowerCase().endsWith(suf.toLowerCase())) continue;
                unit = u;
                s2 = s2.substring(0, s2.length() - suf.length()).trim();
                break block2;
            }
        }
        try {
            numeric = this.doMath ? new ExpressionBuilder(s2).operator(Operators.operators).functions(Functions.functions).build().evaluate() : Double.parseDouble(s2);
        }
        catch (Exception ex) {
            MythicLogger.error("Invalid angle expression: " + this.strValue);
            MythicLogger.handleMinorError(ex);
            return new Angle(0.0, unit);
        }
        return new Angle(numeric, unit);
    }

    @Override
    public Angle get(SkillCaster caster) {
        return this.get(new GenericPlaceholderMeta(caster, caster.getEntity()));
    }

    public String toString() {
        return this.strValue;
    }

    public static PlaceholderAngleImpl of(String string, AngleUnit defaultUnit) {
        try {
            if (string == null) {
                return null;
            }
            if (io.lumine.mythic.bukkit.utils.numbers.RandomAngle.matchesRange(string)) {
                return new RandomAngle(string, defaultUnit);
            }
            if (Angle.isAngle(string)) {
                return new StaticAngle(string, defaultUnit);
            }
            if (!MythicBukkit.isVolatile()) {
                MythicLogger.error("Failed to parse Placeholder '" + string + "': Math and variables in numeric values require premium! Consider getting MythicMobs Premium at www.mythiccraft.io");
                return new StaticAngle("0", AngleUnit.DEGREES);
            }
            return new PlaceholderAngleImpl(string, defaultUnit);
        }
        catch (Exception exception) {
            MythicLogger.error("Failed to parse Placeholder '" + string + "': invalid syntax.");
            return new StaticAngle("0", AngleUnit.DEGREES);
        }
    }

    @Override
    public boolean isStaticallyEqualTo(Angle value) {
        return this.isStatic() && this.get().equals(value);
    }
}

