/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.all;

import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.types.MetaPlaceholder;
import io.lumine.mythic.core.skills.variables.types.ItemVariable;
import io.lumine.mythic.core.utils.annotations.MythicPlaceholder;
import java.util.Optional;

@MythicPlaceholder(placeholder="mythicitem", version="5.4")
public class MythicItemPlaceholder
implements MetaPlaceholder {
    private final PlaceholderExecutor manager;
    private String output;

    public MythicItemPlaceholder(PlaceholderExecutor manager) {
        this.manager = manager;
    }

    @Override
    public String apply(PlaceholderMeta meta, String input) {
        String in = PlaceholderString.of(input).get(meta);
        String[] split = in.split("\\.");
        String itemName = split[0];
        String attribute = split[1];
        Optional<MythicItem> maybeItem = ((MythicBukkit)this.manager.getPlugin()).getItemManager().getItem(itemName);
        if (maybeItem.isEmpty()) {
            return "[Item Not Found]";
        }
        MythicItem mythicItem = maybeItem.get();
        return switch (attribute) {
            case "material" -> mythicItem.getMaterial().toString();
            case "model" -> String.valueOf(mythicItem.getCustomModelData());
            case "display" -> mythicItem.getDisplayName();
            case "itemstack" -> ItemVariable.Utils.serializeToString((BukkitItemStack)mythicItem.generateItemStack(1));
            default -> "[Invalid Attribute]";
        };
    }
}

