/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.all;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;

public class EntityNumericPlaceholder {
    protected final PlaceholderExecutor manager;
    private int rounding = -1;

    public EntityNumericPlaceholder(PlaceholderExecutor manager, MythicLineConfig config) {
        this.manager = manager;
        if (config == null) {
            return;
        }
        this.rounding = config.getInteger(new String[]{"rounding", "round", "r"}, 2);
    }

    public EntityNumericPlaceholder(PlaceholderExecutor manager, MythicLineConfig config, int rounding) {
        this.manager = manager;
        this.rounding = rounding;
        if (config == null) {
            return;
        }
        this.rounding = config.getInteger(new String[]{"rounding", "round", "r"}, rounding);
    }

    protected String format(Number number) {
        if (this.rounding < 0) {
            return String.valueOf(number.doubleValue());
        }
        if (this.rounding == 0) {
            return String.valueOf(Numbers.toInt(Numbers.round(number.doubleValue(), this.rounding)));
        }
        return String.valueOf(Numbers.round(number.doubleValue(), this.rounding));
    }
}

