/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders.all;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.placeholders.PlaceholderBoolean;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.types.MetaPlaceholder;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicPlaceholder;
import java.util.ArrayList;
import java.util.List;

@MythicPlaceholder(placeholder="centertext", version="5.10.1")
public class CenterTextPlaceholder
implements MetaPlaceholder {
    private List<Character> singlePixels = new ArrayList<Character>(List.of(Character.valueOf(' '), Character.valueOf(' '), Character.valueOf(' '), Character.valueOf(' ')));
    private MythicLineConfig config;
    private PlaceholderString value;
    private PlaceholderInt pixelWidth;
    private PlaceholderBoolean bold;

    public CenterTextPlaceholder(PlaceholderExecutor manager, MythicLineConfig config, String[] args) {
        this.value = config.getPlaceholderString(new String[]{"value", "v", "text", "line"}, "", new String[0]);
        this.pixelWidth = config.getPlaceholderInteger(new String[]{"pixelwidth", "width", "w", "pw"}, 100, new String[0]);
        String singlePixelsString = config.getString(new String[]{"singlepixelunicodes", "spus", "spu", "singleunicodes"}, " , , , ", new String[0]);
        this.bold = config.getPlaceholderBoolean(new String[]{"bold", "b"}, (Boolean)false);
        String[] singlePixelArray = singlePixelsString.split(",");
        for (int i = 0; i < 4; ++i) {
            String unicode = i < singlePixelArray.length ? singlePixelArray[i] : " ";
            this.singlePixels.set(i, Character.valueOf(unicode.charAt(0)));
        }
    }

    @Override
    public String apply(PlaceholderMeta meta, String input) {
        String line = this.value.get(meta);
        return MythicUtil.getCenteredText(line, this.pixelWidth.get(meta), this.bold.get(meta), this.singlePixels);
    }
}

