/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.adapters.BukkitItemStack;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillString;
import io.lumine.mythic.core.skills.placeholders.Placeholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderExecutor;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.placeholders.all.MetaTargetPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.EntityPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.GeneralPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.ItemPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.LocationPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.MetaPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.SpawnerPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.TargetPlaceholder;
import io.lumine.mythic.core.skills.placeholders.types.WorldPlaceholder;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class PlaceholderParser {
    protected String strValue;
    protected String strUnparsedValue;
    protected boolean papi;
    protected List<FoundPlaceholder> placeholders;
    protected boolean hasItemPlaceholders;
    protected boolean doMath = false;

    public PlaceholderParser() {
    }

    public PlaceholderParser(String string) {
        if (string == null) {
            this.strValue = null;
            this.strUnparsedValue = null;
            this.placeholders = null;
            this.hasItemPlaceholders = false;
            this.papi = false;
            return;
        }
        try {
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            } else if (string.startsWith("'") && string.endsWith("'")) {
                string = string.substring(1, string.length() - 1);
            }
        }
        catch (Exception ex) {
            MythicLogger.error("Message '" + string + "' is incorrectly configured.");
            string = "INCORRECTLY CONFIGURED. SEE CONSOLE ON RELOAD.";
        }
        this.strUnparsedValue = SkillString.convertLegacyVariables(string);
        this.strValue = SkillString.parseMessageSpecialChars(this.strUnparsedValue);
        if (this.strValue.startsWith("eval ")) {
            this.doMath = true;
            string = string.substring(5);
        } else if (this.strValue.contains("+") || this.strValue.contains("-") || this.strValue.contains("*") || this.strValue.contains("/") || this.strValue.contains("^")) {
            this.doMath = true;
        }
        this.papi = MythicBukkit.inst().getCompatibility().getPlaceholderAPI().isPresent() && this.strUnparsedValue.contains("%");
        this.getPlaceholderManager().registerParser(this);
        this.checkForVariables();
    }

    public void checkForVariables() {
        List<String> found = PlaceholderExecutor.parsePlaceholders(this.strValue);
        if (!found.isEmpty()) {
            LinkedHashMap<String, FoundPlaceholder> map = new LinkedHashMap<String, FoundPlaceholder>();
            boolean hasItem = false;
            for (String key : found) {
                FoundPlaceholder fp = (FoundPlaceholder)map.get(key);
                if (fp == null) {
                    PlaceholderExecutor.PlaceholderEntry entry = this.getPlaceholderManager().getPlaceholder(key);
                    if (entry == null) continue;
                    fp = new FoundPlaceholder(key, entry);
                    if (fp.kind == 7) {
                        hasItem = true;
                    }
                    map.put(key, fp);
                }
                ++fp.count;
            }
            if (!map.isEmpty()) {
                this.placeholders = new ArrayList(map.values());
                this.hasItemPlaceholders = hasItem;
            } else {
                this.placeholders = null;
                this.hasItemPlaceholders = false;
            }
        } else {
            this.placeholders = null;
            this.hasItemPlaceholders = false;
        }
    }

    private static String replaceFirstLiteral(String input, String token, String replacement) {
        if (replacement == null) {
            throw new NullPointerException();
        }
        int idx = input.indexOf(token);
        if (idx < 0) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input.length() - token.length() + replacement.length());
        sb.append(input, 0, idx);
        sb.append(replacement);
        sb.append(input, idx + token.length(), input.length());
        return sb.toString();
    }

    protected String parse() {
        if (this.placeholders == null || this.placeholders.isEmpty()) {
            return this.strValue;
        }
        String string = this.strValue;
        for (FoundPlaceholder found : this.placeholders) {
            if (found.kind != 1) continue;
            try {
                GeneralPlaceholder pl = (GeneralPlaceholder)found.placeholder;
                for (int i = 0; i < found.count; ++i) {
                    string = PlaceholderParser.replaceFirstLiteral(string, found.token, (String)pl.apply(found.arg));
                }
            }
            catch (NullPointerException ex) {
                MythicLogger.error("Failed to process placeholder " + found.token + " in xPlaceholderString{'" + string + "'}", ex);
            }
        }
        return string;
    }

    protected String parse(PlaceholderMeta data, AbstractEntity target) {
        Object raw;
        SkillMetadata skillMetadata;
        if (this.placeholders == null || this.placeholders.isEmpty()) {
            return this.strValue;
        }
        String string = this.strValue;
        BukkitItemStack equippedItem = null;
        if (this.hasItemPlaceholders && data instanceof SkillMetadata && (skillMetadata = (SkillMetadata)data).getVariables().has("equip-item") && (raw = skillMetadata.getVariables().get("equip-item").get()) instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)raw;
            equippedItem = BukkitAdapter.adapt(itemStack);
        }
        for (FoundPlaceholder found : this.placeholders) {
            try {
                block13: for (int i = 0; i < found.count; ++i) {
                    switch (found.kind) {
                        case 1: {
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, (String)((GeneralPlaceholder)found.placeholder).apply(found.arg));
                            continue block13;
                        }
                        case 2: {
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, (String)((MetaPlaceholder)found.placeholder).apply(data, found.arg));
                            continue block13;
                        }
                        case 3: {
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, (String)((EntityPlaceholder)found.placeholder).apply(target, found.arg));
                            continue block13;
                        }
                        case 4: {
                            if (target == null) continue block13;
                            AbstractLocation location = target.getLocation();
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, ((LocationPlaceholder)found.placeholder).apply(location, found.arg));
                            continue block13;
                        }
                        case 5: {
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, ((TargetPlaceholder)found.placeholder).apply(data, target, found.arg));
                            continue block13;
                        }
                        case 6: {
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, (String)((MetaTargetPlaceholder)found.placeholder).apply(data, target, found.arg));
                            continue block13;
                        }
                        case 7: {
                            if (equippedItem == null) continue block13;
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, ((ItemPlaceholder)found.placeholder).apply(equippedItem, found.arg));
                            continue block13;
                        }
                        case 8: {
                            if (target == null) continue block13;
                            AbstractWorld world = target.getWorld();
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, ((WorldPlaceholder)found.placeholder).apply(world, found.arg));
                        }
                    }
                }
            }
            catch (NullPointerException ex) {
                MythicLogger.error("Failed to process placeholder " + found.token + " in xPlaceholderString{'" + string + "'}", ex);
            }
        }
        return string;
    }

    protected String parse(PlaceholderMeta data, AbstractLocation target) {
        Object raw;
        SkillMetadata skillMetadata;
        if (this.placeholders == null || this.placeholders.isEmpty()) {
            return this.strValue;
        }
        String string = this.strValue;
        BukkitItemStack equippedItem = null;
        if (this.hasItemPlaceholders && data instanceof SkillMetadata && (skillMetadata = (SkillMetadata)data).getVariables().has("equip-item") && (raw = skillMetadata.getVariables().get("equip-item").get()) instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)raw;
            equippedItem = BukkitAdapter.adapt(itemStack);
        }
        for (FoundPlaceholder found : this.placeholders) {
            try {
                block10: for (int i = 0; i < found.count; ++i) {
                    switch (found.kind) {
                        case 1: {
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, (String)((GeneralPlaceholder)found.placeholder).apply(found.arg));
                            continue block10;
                        }
                        case 2: {
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, (String)((MetaPlaceholder)found.placeholder).apply(data, found.arg));
                            continue block10;
                        }
                        case 4: {
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, ((LocationPlaceholder)found.placeholder).apply(target, found.arg));
                            continue block10;
                        }
                        case 7: {
                            if (equippedItem == null) continue block10;
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, ((ItemPlaceholder)found.placeholder).apply(equippedItem, found.arg));
                            continue block10;
                        }
                        case 8: {
                            if (target == null) continue block10;
                            AbstractWorld world = target.getWorld();
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, ((WorldPlaceholder)found.placeholder).apply(world, found.arg));
                        }
                    }
                }
            }
            catch (NullPointerException ex) {
                MythicLogger.error("Failed to process placeholder " + found.token + " in xPlaceholderString{'" + string + "'}", ex);
            }
        }
        return string;
    }

    protected String parse(PlaceholderMeta data, AbstractItemStack itemStack) {
        if (this.placeholders == null || this.placeholders.isEmpty() || itemStack == null) {
            return this.strValue;
        }
        String string = this.strValue;
        for (FoundPlaceholder found : this.placeholders) {
            try {
                block8: for (int i = 0; i < found.count; ++i) {
                    switch (found.kind) {
                        case 1: {
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, (String)((GeneralPlaceholder)found.placeholder).apply(found.arg));
                            continue block8;
                        }
                        case 2: {
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, (String)((MetaPlaceholder)found.placeholder).apply(data, found.arg));
                            continue block8;
                        }
                        case 7: {
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, ((ItemPlaceholder)found.placeholder).apply(itemStack, found.arg));
                        }
                    }
                }
            }
            catch (NullPointerException ex) {
                MythicLogger.error("Failed to process placeholder " + found.token + " in xPlaceholderString{'" + string + "'}", ex);
            }
        }
        return string;
    }

    protected String parse(MythicSpawner spawner) {
        if (this.placeholders == null || this.placeholders.isEmpty() || spawner == null) {
            return this.strValue;
        }
        String string = this.strValue;
        for (FoundPlaceholder found : this.placeholders) {
            try {
                block8: for (int i = 0; i < found.count; ++i) {
                    switch (found.kind) {
                        case 1: {
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, (String)((GeneralPlaceholder)found.placeholder).apply(found.arg));
                            continue block8;
                        }
                        case 9: {
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, ((SpawnerPlaceholder)found.placeholder).apply(spawner, found.arg));
                            continue block8;
                        }
                        case 8: {
                            AbstractWorld world = spawner.getLocation().getWorld();
                            string = PlaceholderParser.replaceFirstLiteral(string, found.token, ((WorldPlaceholder)found.placeholder).apply(world, found.arg));
                        }
                    }
                }
            }
            catch (NullPointerException ex) {
                MythicLogger.error("Failed to process placeholder " + found.token + " in xPlaceholderString{'" + string + "'}", ex);
            }
        }
        return string;
    }

    public boolean isStatic() {
        return (this.placeholders == null || this.placeholders.isEmpty()) && !this.doMath && !this.papi;
    }

    public boolean isPresent() {
        return this.strValue != null && !this.strValue.isEmpty();
    }

    protected PlaceholderExecutor getPlaceholderManager() {
        return MythicBukkit.inst().getPlaceholderManager();
    }

    public String serialize() {
        return this.strUnparsedValue;
    }

    public boolean isDoMath() {
        return this.doMath;
    }

    public void setDoMath(boolean doMath) {
        this.doMath = doMath;
    }

    protected static class FoundPlaceholder {
        protected static final byte KIND_GENERAL = 1;
        protected static final byte KIND_META = 2;
        protected static final byte KIND_ENTITY = 3;
        protected static final byte KIND_LOCATION = 4;
        protected static final byte KIND_TARGET = 5;
        protected static final byte KIND_METATARGET = 6;
        protected static final byte KIND_ITEM = 7;
        protected static final byte KIND_WORLD = 8;
        protected static final byte KIND_SPAWNER = 9;
        protected final String token;
        protected final String arg;
        protected final Placeholder placeholder;
        protected final byte kind;
        protected int count;

        protected FoundPlaceholder(String key, PlaceholderExecutor.PlaceholderEntry entry) {
            Placeholder pl;
            this.token = "<" + key + ">";
            this.arg = entry.getArg();
            this.placeholder = pl = entry.getPlaceholder();
            this.kind = pl instanceof GeneralPlaceholder ? (byte)1 : (pl instanceof MetaPlaceholder ? (byte)2 : (pl instanceof EntityPlaceholder ? (byte)3 : (pl instanceof LocationPlaceholder ? (byte)4 : (pl instanceof TargetPlaceholder ? (byte)5 : (pl instanceof MetaTargetPlaceholder ? (byte)6 : (pl instanceof ItemPlaceholder ? (byte)7 : (pl instanceof WorldPlaceholder ? (byte)8 : (pl instanceof SpawnerPlaceholder ? (byte)9 : (byte)0))))))));
        }
    }
}

