/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.placeholders;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.packs.Pack;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.placeholders.PlaceholderManager;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.types.NodeListProp;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.config.Scope;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.MetaSkill;
import io.lumine.mythic.core.skills.placeholders.Placeholder;
import io.lumine.mythic.core.skills.placeholders.PlaceholderParser;
import io.lumine.mythic.core.skills.placeholders.StaticPlaceholderRegistry;
import io.lumine.mythic.core.skills.placeholders.all.ConditionalPlaceholder;
import io.lumine.mythic.core.skills.placeholders.all.RandomLinePlaceholder;
import io.lumine.mythic.core.skills.placeholders.all.StaticPlaceholder;
import io.lumine.mythic.core.utils.annotations.AnnotationUtil;
import io.lumine.mythic.core.utils.annotations.MythicPlaceholder;
import java.io.File;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;

public class PlaceholderExecutor
extends ReloadableModule<MythicBukkit>
implements PlaceholderManager {
    private static final NodeListProp NODES = Property.NodeList(Scope.PACK, "");
    private static final DecimalFormat df = new DecimalFormat("0.00");
    private final StaticPlaceholderRegistry staticPlaceholderRegistry = new StaticPlaceholderRegistry();
    private List<PlaceholderParser> parsers = Lists.newArrayList();
    private PlaceholderClassTree placeholderClasses = new PlaceholderClassTree();
    private final Map<String, PlaceholderEntry> placeholderCache = new ConcurrentHashMap<String, PlaceholderEntry>();
    private boolean initialized = false;
    private boolean acceptingRegisteredParsers = true;
    private int saved = 0;

    public PlaceholderExecutor(MythicBukkit plugin) {
        super(plugin, false);
    }

    @Override
    public void unload() {
        this.parsers.clear();
        this.staticPlaceholderRegistry.clear();
    }

    @Override
    public void load(MythicBukkit plugin) {
        this.initialized = false;
        this.acceptingRegisteredParsers = true;
        this.placeholderCache.clear();
        this.register("caster.enchantlevel", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getEntity().getEnchantmentLevel((String)arg))));
        this.register("caster.heldenchantlevel", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getEntity().getEnchantmentLevelHeld((String)arg))));
        this.register("caster.tt.top", (Placeholder)Placeholder.meta((meta, arg) -> {
            ActiveMob am;
            if (meta.getCaster() instanceof ActiveMob && (am = (ActiveMob)meta.getCaster()).hasThreatTable() && am.getThreatTable().inCombat()) {
                return am.getThreatTable().getTopThreatHolder().getName();
            }
            return "Unknown";
        }));
        this.register("caster.tt.size", (Placeholder)Placeholder.meta((meta, arg) -> {
            ActiveMob am;
            if (meta.getCaster() instanceof ActiveMob && (am = (ActiveMob)meta.getCaster()).hasThreatTable()) {
                return String.valueOf(am.getThreatTable().size());
            }
            return String.valueOf(0);
        }));
        this.register("caster.children.size", (Placeholder)Placeholder.meta((meta, arg) -> String.valueOf(meta.getCaster().getChildren().size())));
        this.register("caster.skill", (Placeholder)Placeholder.meta((meta, arg) -> {
            String[] split = arg.split("\\.");
            Optional<Skill> maybeSkill = ((MythicBukkit)this.getPlugin()).getSkillManager().getSkill(split[0]);
            if (!maybeSkill.isPresent()) {
                return "Skill Not Found";
            }
            MetaSkill skill = (MetaSkill)maybeSkill.get();
            if ("cooldown".equalsIgnoreCase(split[1])) {
                if (split.length > 2 && "millis".equals(split[2])) {
                    return String.valueOf(skill.getCooldown(meta.getCaster()));
                }
                return String.valueOf(Numbers.round(skill.getCooldown(meta.getCaster()), 2));
            }
            return "Invalid Placeholder";
        }));
        this.register("trigger.pity", (Placeholder)Placeholder.meta((meta, arg) -> {
            AbstractEntity target = meta.getTrigger();
            if (!target.isPlayer()) {
                return "0";
            }
            if (arg == null) {
                arg = "DEFAULT";
            }
            return String.valueOf(((MythicBukkit)this.getPlugin()).getDropManager().getPityManager().getPity(target.getUniqueId(), (String)arg));
        }));
        this.register("trigger.held.item", (Placeholder)Placeholder.meta((meta, arg) -> {
            AbstractEntity trigger = meta.getTrigger();
            if (trigger == null || !trigger.isLiving()) {
                return "AIR";
            }
            LivingEntity entity = (LivingEntity)trigger.getBukkitEntity();
            if (entity.getEquipment().getItemInMainHand() == null) {
                return "AIR";
            }
            return entity.getEquipment().getItemInMainHand().getType().toString();
        }));
        this.register("trigger.item.amount", (Placeholder)Placeholder.meta((entity, arg) -> {
            Entity patt0$temp = entity.getTrigger().getBukkitEntity();
            if (!(patt0$temp instanceof Item)) {
                return "0";
            }
            Item item = (Item)patt0$temp;
            return String.valueOf(item.getItemStack().getAmount());
        }));
        this.register("trigger.item.type", (Placeholder)Placeholder.meta((entity, arg) -> {
            Entity patt0$temp = entity.getTrigger().getBukkitEntity();
            if (!(patt0$temp instanceof Item)) {
                return "air";
            }
            Item item = (Item)patt0$temp;
            return item.getItemStack().getType().toString();
        }));
        this.register("trigger.item.model", (Placeholder)Placeholder.meta((entity, arg) -> {
            Entity patt0$temp = entity.getTrigger().getBukkitEntity();
            if (!(patt0$temp instanceof Item)) {
                return "0";
            }
            Item item = (Item)patt0$temp;
            return String.valueOf(item.getItemStack().getItemMeta().getCustomModelData());
        }));
        this.register("target.ydiff", (Placeholder)Placeholder.target((meta, entity, arg) -> {
            double tY = entity.getLocation().getY();
            double cY = meta.getCaster().getEntity().getLocation().getY();
            return String.valueOf(tY - cY);
        }));
        this.register("target.block.type", (Placeholder)Placeholder.location((location, arg) -> {
            try {
                return BukkitAdapter.adapt(location).getBlock().getType().toString();
            }
            catch (Exception ex) {
                return "AIR";
            }
        }));
        this.register("target.block.data", (Placeholder)Placeholder.location((location, args) -> {
            Block block = BukkitAdapter.adapt(location).getBlock();
            return block.getBlockData().getAsString();
        }));
        this.register("target.block.hardness", (Placeholder)Placeholder.location((location, arg) -> {
            try {
                return String.valueOf(BukkitAdapter.adapt(location).getBlock().getType().getHardness());
            }
            catch (Exception ex) {
                return "0";
            }
        }));
        this.register("target.held.item", (Placeholder)Placeholder.target((meta, target, arg) -> {
            if (target == null || !target.isLiving()) {
                return "AIR";
            }
            LivingEntity entity = (LivingEntity)target.getBukkitEntity();
            if (entity.getEquipment().getItemInMainHand() == null) {
                return "AIR";
            }
            return entity.getEquipment().getItemInMainHand().getType().toString();
        }));
        this.register("spawner.pir", (Placeholder)Placeholder.spawner((spawner, arg) -> {
            double radius = spawner.getScalingRange();
            int players = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(spawner.getLocation(), radius, entity -> entity.isPlayer()).size();
            return String.valueOf(players);
        }));
        Collection<Class<?>> placeholderClasses = AnnotationUtil.getAnnotatedClasses(this.getPlugin(), "io.lumine.mythic.core.skills.placeholders.all", MythicPlaceholder.class);
        for (Class<Placeholder> clazz : placeholderClasses) {
            try {
                MythicPlaceholder anno = clazz.getAnnotation(MythicPlaceholder.class);
                String name = anno.placeholder();
                if (!Placeholder.class.isAssignableFrom(clazz)) continue;
                this.register(name, clazz);
                for (String alias : anno.aliases()) {
                    this.register(alias, clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load placeholder {0}", clazz.getCanonicalName());
            }
        }
        for (Pack pack : ((MythicBukkit)this.getPlugin()).getPackManager().getPacks()) {
            File file = pack.getPackFile("placeholders.yml");
            if (!file.exists()) continue;
            MythicConfigImpl baseConfig = new MythicConfigImpl(file);
            for (String node : baseConfig.getKeys("")) {
                if (baseConfig.isConfigurationSection(node)) {
                    this.register("placeholder." + node, (Placeholder)new ConditionalPlaceholder(this, node, baseConfig.getNestedConfig(node)));
                    continue;
                }
                if (baseConfig.isList(node)) {
                    this.register("placeholder." + node, (Placeholder)new RandomLinePlaceholder(this, baseConfig.getStringList(node)));
                    continue;
                }
                String value = baseConfig.getString(node);
                this.register("placeholder." + node, (Placeholder)new StaticPlaceholder(value));
            }
        }
        this.staticPlaceholderRegistry.compile();
        this.initialized = true;
    }

    @Override
    public void register(String[] keys, Placeholder transformer) {
        for (String key : keys) {
            this.register(key, transformer);
        }
    }

    @Override
    public void register(String key, Placeholder transformer) {
        if (transformer instanceof StaticPlaceholder) {
            StaticPlaceholder staticPlaceholder = (StaticPlaceholder)transformer;
            this.staticPlaceholderRegistry.register(key, staticPlaceholder.apply());
        }
        String[] split = key.split("\\.");
        PlaceholderClassTree ref = this.placeholderClasses;
        for (int i = 0; i <= split.length; ++i) {
            if (i == split.length) {
                ref.setPlaceholder(transformer);
                continue;
            }
            if (!ref.getSubPlaceholders().containsKey(split[i])) {
                ref.getSubPlaceholders().put(split[i], new PlaceholderClassTree());
            }
            ref = ref.getSubPlaceholders().get(split[i]);
        }
        if (this.initialized) {
            this.recheckForPlaceholders();
        }
    }

    public void register(String[] keys, Class<Placeholder> transformer) {
        for (String key : keys) {
            this.register(key, transformer);
        }
    }

    public void register(String key, Class<Placeholder> transformer) {
        String[] split = key.split("\\.");
        PlaceholderClassTree ref = this.placeholderClasses;
        for (int i = 0; i <= split.length; ++i) {
            if (i == split.length) {
                ref.setPlaceholderClass(transformer);
                continue;
            }
            if (!ref.getSubPlaceholders().containsKey(split[i])) {
                ref.getSubPlaceholders().put(split[i], new PlaceholderClassTree());
            }
            ref = ref.getSubPlaceholders().get(split[i]);
        }
        if (this.initialized) {
            this.recheckForPlaceholders();
        }
    }

    @Override
    public PlaceholderEntry getPlaceholder(String key) {
        if (key.startsWith("&")) {
            return null;
        }
        PlaceholderEntry cached = this.placeholderCache.get(key);
        if (cached != null) {
            return cached;
        }
        PlaceholderEntry entry = this.resolvePlaceholder(key);
        if (entry != null && entry.getPlaceholder() != null) {
            this.placeholderCache.put(key, entry);
        }
        return entry;
    }

    private PlaceholderEntry resolvePlaceholder(String key) {
        String[] split = PlaceholderExecutor.splitByDots(key);
        PlaceholderClassTree ref = this.placeholderClasses;
        String arg = null;
        ArrayList<String> argsList = new ArrayList<String>();
        MythicLineConfigImpl config = null;
        for (int i = 0; i < split.length; ++i) {
            String currentKey = split[i];
            if (currentKey.contains("{") || currentKey.contains("}")) {
                config = MythicLineConfigImpl.of(currentKey);
                currentKey = config.getKey();
            }
            if (ref.getSubPlaceholders().containsKey(currentKey)) {
                ref = ref.getSubPlaceholders().get(currentKey);
                continue;
            }
            arg = arg == null ? currentKey : arg + "." + currentKey;
            argsList.add(currentKey);
        }
        Placeholder placeholder = null;
        if (ref.getPlaceholderClass() != null) {
            Class<Placeholder> placeholderClass = ref.getPlaceholderClass();
            Object[] args = argsList.toArray(new String[0]);
            try {
                Constructor<Placeholder> placeholderConstructor = placeholderClass.getConstructor(PlaceholderExecutor.class, MythicLineConfig.class, String[].class);
                placeholder = placeholderConstructor.newInstance(this, config, args);
            }
            catch (Throwable ex) {
                try {
                    Constructor<Placeholder> placeholderConstructor = placeholderClass.getConstructor(PlaceholderExecutor.class, String[].class);
                    placeholder = placeholderConstructor.newInstance(this, args);
                }
                catch (Throwable ex2) {
                    try {
                        Constructor<Placeholder> placeholderConstructor = placeholderClass.getConstructor(PlaceholderExecutor.class);
                        placeholder = placeholderConstructor.newInstance(this);
                    }
                    catch (Throwable ex3) {
                        try {
                            Constructor<Placeholder> placeholderConstructor = placeholderClass.getConstructor(String[].class);
                            placeholder = placeholderConstructor.newInstance(args);
                        }
                        catch (Throwable ex4) {
                            try {
                                Constructor<Placeholder> placeholderConstructor = placeholderClass.getConstructor(new Class[0]);
                                placeholder = placeholderConstructor.newInstance(new Object[0]);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            }
        } else if (ref.getPlaceholder() != null) {
            placeholder = ref.getPlaceholder();
        }
        return new PlaceholderEntry(placeholder, arg);
    }

    @Override
    public void registerParser(PlaceholderParser placeholderParser) {
        if (this.acceptingRegisteredParsers) {
            this.parsers.add(placeholderParser);
        }
    }

    @Override
    public void recheckForPlaceholders() {
        ArrayList parsers = Lists.newArrayList(this.parsers);
        parsers.forEach(parser -> parser.checkForVariables());
    }

    public static List<String> parsePlaceholders(String input) {
        int loopStartIndex;
        ArrayList<String> matches = new ArrayList<String>();
        Stack<Integer> bracketIndices = new Stack<Integer>();
        int startIndex = -1;
        for (int i = loopStartIndex = input.startsWith("<<") || input.startsWith(">>") ? 1 : 0; i < input.length(); ++i) {
            if (input.charAt(i) == '<') {
                if (bracketIndices.isEmpty()) {
                    startIndex = i;
                }
                bracketIndices.push(i);
                continue;
            }
            if (input.charAt(i) != '>' || bracketIndices.isEmpty()) continue;
            int endIndex = i;
            bracketIndices.pop();
            if (!bracketIndices.isEmpty() || startIndex == -1) continue;
            matches.add(input.substring(startIndex + 1, endIndex));
            startIndex = -1;
        }
        return matches;
    }

    private static String[] splitByDots(String input) {
        String placeholder = "<&dot>";
        Pattern pattern = Pattern.compile("<[^>]*>|\\{[^}]*}");
        Matcher matcher = pattern.matcher(input);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, matcher.group().replace(".", placeholder));
        }
        matcher.appendTail(buffer);
        String replacedString = buffer.toString();
        String[] split = replacedString.split("\\.");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].replace(placeholder, ".");
        }
        return split;
    }

    public StaticPlaceholderRegistry getStaticPlaceholderRegistry() {
        return this.staticPlaceholderRegistry;
    }

    public List<PlaceholderParser> getParsers() {
        return this.parsers;
    }

    public boolean isAcceptingRegisteredParsers() {
        return this.acceptingRegisteredParsers;
    }

    public void setAcceptingRegisteredParsers(boolean acceptingRegisteredParsers) {
        this.acceptingRegisteredParsers = acceptingRegisteredParsers;
    }

    private class PlaceholderClassTree {
        private Class<Placeholder> placeholderClass = null;
        private Placeholder placeholder = null;
        private Map<String, PlaceholderClassTree> subPlaceholders = new HashMap<String, PlaceholderClassTree>();

        public Class<Placeholder> getPlaceholderClass() {
            return this.placeholderClass;
        }

        public Placeholder getPlaceholder() {
            return this.placeholder;
        }

        public Map<String, PlaceholderClassTree> getSubPlaceholders() {
            return this.subPlaceholders;
        }

        public void setPlaceholderClass(Class<Placeholder> placeholderClass) {
            this.placeholderClass = placeholderClass;
        }

        public void setPlaceholder(Placeholder placeholder) {
            this.placeholder = placeholder;
        }

        public void setSubPlaceholders(Map<String, PlaceholderClassTree> subPlaceholders) {
            this.subPlaceholders = subPlaceholders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlaceholderClassTree)) {
                return false;
            }
            PlaceholderClassTree other = (PlaceholderClassTree)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<Placeholder> this$placeholderClass = this.getPlaceholderClass();
            Class<Placeholder> other$placeholderClass = other.getPlaceholderClass();
            if (this$placeholderClass == null ? other$placeholderClass != null : !this$placeholderClass.equals(other$placeholderClass)) {
                return false;
            }
            Placeholder this$placeholder = this.getPlaceholder();
            Placeholder other$placeholder = other.getPlaceholder();
            if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
                return false;
            }
            Map<String, PlaceholderClassTree> this$subPlaceholders = this.getSubPlaceholders();
            Map<String, PlaceholderClassTree> other$subPlaceholders = other.getSubPlaceholders();
            return !(this$subPlaceholders == null ? other$subPlaceholders != null : !((Object)this$subPlaceholders).equals(other$subPlaceholders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlaceholderClassTree;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<Placeholder> $placeholderClass = this.getPlaceholderClass();
            result = result * 59 + ($placeholderClass == null ? 43 : $placeholderClass.hashCode());
            Placeholder $placeholder = this.getPlaceholder();
            result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
            Map<String, PlaceholderClassTree> $subPlaceholders = this.getSubPlaceholders();
            result = result * 59 + ($subPlaceholders == null ? 43 : ((Object)$subPlaceholders).hashCode());
            return result;
        }

        public String toString() {
            return "PlaceholderExecutor.PlaceholderClassTree(placeholderClass=" + String.valueOf(this.getPlaceholderClass()) + ", placeholder=" + String.valueOf(this.getPlaceholder()) + ", subPlaceholders=" + String.valueOf(this.getSubPlaceholders()) + ")";
        }
    }

    public class PlaceholderEntry {
        private final Placeholder placeholder;
        private final String arg;

        public PlaceholderEntry(Placeholder p, String a) {
            this.placeholder = p;
            this.arg = a != null ? a : "null";
        }

        public Placeholder getPlaceholder() {
            return this.placeholder;
        }

        public String getArg() {
            return this.arg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlaceholderEntry)) {
                return false;
            }
            PlaceholderEntry other = (PlaceholderEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Placeholder this$placeholder = this.getPlaceholder();
            Placeholder other$placeholder = other.getPlaceholder();
            if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
                return false;
            }
            String this$arg = this.getArg();
            String other$arg = other.getArg();
            return !(this$arg == null ? other$arg != null : !this$arg.equals(other$arg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlaceholderEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Placeholder $placeholder = this.getPlaceholder();
            result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
            String $arg = this.getArg();
            result = result * 59 + ($arg == null ? 43 : $arg.hashCode());
            return result;
        }

        public String toString() {
            return "PlaceholderExecutor.PlaceholderEntry(placeholder=" + String.valueOf(this.getPlaceholder()) + ", arg=" + this.getArg() + ")";
        }
    }
}

