/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IMetaSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.conditions.ISkillMetaCondition;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.conditions.InvalidCondition;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@MythicMechanic(author="Seyarada", name="switch", description="Acts as a switch/case")
public class SwitchMechanic
extends SkillMechanic
implements IMetaSkill {
    final Map<String, Skill> caseSkills = new HashMap<String, Skill>();
    boolean uniqueResult;
    PlaceholderString baseCondition;
    Skill defaultSkill;

    public SwitchMechanic(SkillExecutor manager, File file, String mlcLine, MythicLineConfig mlc) {
        super(manager, file, mlcLine, mlc);
        this.uniqueResult = mlc.getBoolean(new String[]{"uniqueresult", "unique", "first"}, true);
        this.baseCondition = mlc.getPlaceholderString("condition", "");
        List<String[]> cases = SwitchMechanic.parseCases(mlc.getString("cases"));
        this.getManager().queueSecondPass(() -> {
            for (String[] pair : cases) {
                String condition = pair[0];
                String skillString = pair[1];
                Optional<Skill> skill = this.getManager().getSkill(file, this, skillString);
                skill.ifPresent(metaSkill -> {
                    if (metaSkill.isInlineSkill()) {
                        metaSkill.addParent(this);
                    }
                    if (condition.equalsIgnoreCase("default")) {
                        this.defaultSkill = metaSkill;
                    } else {
                        this.caseSkills.put(condition, (Skill)metaSkill);
                    }
                });
            }
        });
    }

    @Override
    public SkillResult cast(SkillMetadata meta) {
        String parsedCondition = this.baseCondition.get(meta);
        boolean hasExecuted = false;
        for (Map.Entry<String, Skill> e : this.caseSkills.entrySet()) {
            String conditionCase = PlaceholderString.of(e.getKey()).get(meta);
            Skill skill = e.getValue();
            String caseCondition = parsedCondition.replace("<case>", conditionCase);
            SkillCondition condition = ((MythicBukkit)this.getPlugin()).getSkillManager().getCondition(caseCondition);
            if (condition instanceof InvalidCondition) continue;
            SkillMetadataImpl data = meta.deeperClone();
            if (condition instanceof ISkillMetaCondition) {
                ISkillMetaCondition metaCondition = (ISkillMetaCondition)((Object)condition);
                if (metaCondition.check(data)) {
                    skill.execute(data);
                    hasExecuted = true;
                }
            } else if (condition.evaluateTargets(data)) {
                skill.execute(data);
                hasExecuted = true;
            }
            if (!hasExecuted || !this.uniqueResult) continue;
            break;
        }
        if (!hasExecuted && this.defaultSkill != null) {
            this.defaultSkill.execute(meta);
        }
        return SkillResult.SUCCESS;
    }

    private static List<String[]> parseCases(String casesString) {
        if (casesString == null || casesString.isEmpty()) {
            return List.of();
        }
        ArrayList<Integer> caseStarts = new ArrayList<Integer>();
        int squareDepth = 0;
        int curlyDepth = 0;
        int parenDepth = 0;
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        for (int i = 0; i < casesString.length(); ++i) {
            char c = casesString.charAt(i);
            if (inQuotes) {
                if (c != quoteChar) continue;
                inQuotes = false;
                continue;
            }
            if (c == '\"' || c == '\'') {
                inQuotes = true;
                quoteChar = c;
                continue;
            }
            switch (c) {
                case '[': {
                    ++squareDepth;
                    break;
                }
                case ']': {
                    squareDepth = Math.max(0, squareDepth - 1);
                    break;
                }
                case '{': {
                    ++curlyDepth;
                    break;
                }
                case '}': {
                    curlyDepth = Math.max(0, curlyDepth - 1);
                    break;
                }
                case '(': {
                    ++parenDepth;
                    break;
                }
                case ')': {
                    parenDepth = Math.max(0, parenDepth - 1);
                }
            }
            if (squareDepth != 0 || curlyDepth != 0 || parenDepth != 0 || !SwitchMechanic.matchesCaseToken(casesString, i)) continue;
            caseStarts.add(i);
            i += 3;
        }
        if (caseStarts.isEmpty()) {
            return List.of();
        }
        ArrayList<String[]> results = new ArrayList<String[]>();
        for (int i = 0; i < caseStarts.size(); ++i) {
            String[] pair;
            int end;
            int start = (Integer)caseStarts.get(i) + 4;
            String segment = casesString.substring(start, end = i + 1 < caseStarts.size() ? ((Integer)caseStarts.get(i + 1)).intValue() : casesString.length()).trim();
            if (segment.isEmpty() || (pair = segment.split("=", 2)).length != 2) continue;
            results.add(new String[]{pair[0].trim(), pair[1].trim()});
        }
        return results;
    }

    private static boolean matchesCaseToken(String text, int index) {
        if (index < 0 || index + 4 > text.length()) {
            return false;
        }
        if (!text.regionMatches(true, index, "case", 0, 4)) {
            return false;
        }
        char before = index == 0 ? (char)' ' : (char)text.charAt(index - 1);
        char after = index + 4 >= text.length() ? (char)' ' : (char)text.charAt(index + 4);
        return Character.isWhitespace(before) && Character.isWhitespace(after);
    }
}

