/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;

@MythicMechanic(name="setTextDisplay", aliases={"setText"}, description="Sets the text component of Text Display entity")
public class SetTextDisplayMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    @MythicField(name="text", aliases={"t"}, description="The text to use. If not set, the mechanic will remove the text from the entity instead.", defValue="")
    private final PlaceholderString text;

    public SetTextDisplayMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.text = mlc.getPlaceholderString(new String[]{"text", "t"}, null, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity entity = target.getBukkitEntity();
        if (!(entity instanceof TextDisplay)) {
            return SkillResult.INVALID_TARGET;
        }
        TextDisplay textDisplay = (TextDisplay)entity;
        if (ServerVersion.isPaper()) {
            Component text = MiniMessage.miniMessage().deserializeOrNull(this.text == null ? null : this.text.get((PlaceholderMeta)data, target));
            textDisplay.text(text);
        } else {
            textDisplay.setText(this.text.get((PlaceholderMeta)data, target));
        }
        return SkillResult.SUCCESS;
    }
}

