/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="setProjectileDirection", description="Sets the projectile's current direction to the given target")
public class SetProjectileDirectionMechanic
extends SkillMechanic
implements ITargetedLocationSkill {
    private final double directionFactor;

    public SetProjectileDirectionMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.directionFactor = mlc.getDouble(new String[]{"magnitude", "m"}, 1.0);
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        IParentSkill iParentSkill = data.getCallingEvent();
        if (!(iParentSkill instanceof Projectile.ProjectileTracker)) {
            return SkillResult.INVALID_CONFIG;
        }
        Projectile.ProjectileTracker projectileTracker = (Projectile.ProjectileTracker)iParentSkill;
        AbstractLocation currentLocation = projectileTracker.getCurrentLocation();
        AbstractVector currentDirection = projectileTracker.getCurrentVelocity();
        AbstractVector newDirection = target.toVector().subtract(currentLocation.toVector()).normalize();
        AbstractVector interpolatedDirection = currentDirection.multiply(1.0 - this.directionFactor).add(newDirection.multiply(this.directionFactor)).normalize();
        projectileTracker.setDirection(interpolatedDirection);
        return SkillResult.SUCCESS;
    }
}

