/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="setParent", description="Sets the caster's parent to the target entity")
public class SetParentMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    public SetParentMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        SkillCaster skillCaster = data.getCaster();
        if (skillCaster instanceof ActiveMob) {
            ActiveMob am = (ActiveMob)skillCaster;
            if (target.isPlayer()) {
                try {
                    PlayerData playerData = ((MythicBukkit)this.getPlugin()).getPlayerManager().getProfile(target.asPlayer());
                    am.setParent(playerData);
                    return SkillResult.SUCCESS;
                }
                catch (Error | Exception playerData) {}
            } else {
                ActiveMob mob = ((MythicBukkit)this.getPlugin()).getMobManager().getMythicMobInstance(target);
                if (mob != null) {
                    am.setParent(mob);
                    return SkillResult.SUCCESS;
                }
            }
        }
        return SkillResult.INVALID_TARGET;
    }
}

