/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;

@MythicMechanic(author="Ashijin", name="setItemGroupCooldown", description="Sets the cooldown on an item group for the target player")
public class SetItemGroupCooldownMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected PlaceholderString namespacedKey;
    protected PlaceholderInt ticks;

    public SetItemGroupCooldownMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.namespacedKey = mlc.getPlaceholderString(new String[]{"key", "k", "group", "g"}, "minecraft:item_group", new String[0]);
        this.ticks = mlc.getPlaceholderInteger(new String[]{"ticks", "t"}, 20, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        target.asPlayer().setItemGroupCooldown(this.namespacedKey.get((PlaceholderMeta)data, target), this.ticks.get(data, target));
        return SkillResult.SUCCESS;
    }
}

