/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;

@MythicMechanic(name="setInteractionSize", aliases={"interactionSize"}, description="Sets the interaction hitbox size")
public class SetInteractionSizeMechanic
extends SkillMechanic
implements INoTargetSkill,
ITargetedEntitySkill {
    @MythicField(name="height", aliases={"h"}, description="Sets the interaction height")
    private final PlaceholderFloat height;
    @MythicField(name="width", aliases={"w"}, description="Sets the interaction width")
    private final PlaceholderFloat width;

    public SetInteractionSizeMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.height = mlc.getPlaceholderFloat(new String[]{"height", "h"}, 1.0f, new String[0]);
        this.width = mlc.getPlaceholderFloat(new String[]{"width", "w"}, 1.0f, new String[0]);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Entity entity = target.getBukkitEntity();
        if (!(entity instanceof Interaction)) {
            return SkillResult.INVALID_TARGET;
        }
        Interaction interaction = (Interaction)entity;
        this.setSize(interaction, data);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        Entity entity = data.getCaster().getEntity().getBukkitEntity();
        if (!(entity instanceof Interaction)) {
            return SkillResult.INVALID_TARGET;
        }
        Interaction interaction = (Interaction)entity;
        this.setSize(interaction, data);
        return SkillResult.SUCCESS;
    }

    protected void setSize(Interaction interaction, SkillMetadata data) {
        interaction.setInteractionHeight(this.height.get(data, BukkitAdapter.adapt((Entity)interaction)));
        interaction.setInteractionWidth(this.width.get(data, BukkitAdapter.adapt((Entity)interaction)));
    }
}

