/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.RandomFloat;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", version="4.10", name="recoil", aliases={"effect:recoil", "e:recoil"}, description="Causes the player's screen to recoil")
public class RecoilEffect
extends SkillMechanic
implements ITargetedEntitySkill {
    @MythicField(name="duration", aliases={"d"}, version="4.8", description="How long the effect should last")
    private PlaceholderFloat recoil;
    private RandomFloat pitchMod;
    private RandomFloat yawMod;
    private float sneakingMod;
    private float sprintingMod;

    public RecoilEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.recoil = mlc.getPlaceholderFloat(new String[]{"recoil", "r"}, 1.0f, new String[0]);
        String pitchMod = mlc.getString(new String[]{"pitch", "p"}, "-10to10", new String[0]);
        String yawMod = mlc.getString(new String[]{"yaw", "y"}, "-0.25to0.25", new String[0]);
        this.sneakingMod = mlc.getFloat(new String[]{"sneaking", "sn"}, 0.75f);
        this.sprintingMod = mlc.getFloat(new String[]{"sprinting", "sp"}, 1.25f);
        this.pitchMod = new RandomFloat(pitchMod);
        this.yawMod = new RandomFloat(yawMod);
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (!target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = (Player)target.getBukkitEntity();
        float currentPitch = target.getLocation().getPitch();
        float currentYaw = target.getLocation().getYaw();
        float pitchDelta = this.pitchMod.get();
        float yawDelta = this.yawMod.get();
        if (player.isSneaking()) {
            pitchDelta *= this.sneakingMod;
        } else if (player.isSprinting()) {
            pitchDelta *= this.sprintingMod;
        }
        float recoilValue = this.recoil.get(data);
        ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getEntityHandler().setPlayerRotation(target.asPlayer(), yawDelta *= recoilValue, pitchDelta *= recoilValue, true);
        return SkillResult.SUCCESS;
    }
}

