/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import io.lumine.mythic.core.skills.projectiles.ProjectileBulletType;
import io.lumine.mythic.core.skills.projectiles.ProjectileSurfaceMode;
import io.lumine.mythic.core.utils.BlockUtil;
import io.lumine.mythic.core.utils.MythicUtil;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicFields;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import io.lumine.mythic.core.utils.physics.CollisionHelper;
import io.lumine.mythic.core.utils.physics.PhysicsCollision;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;

@MythicMechanic(author="Ashijin", name="projectile", aliases={"p"}, description="Launches a custom projectile at the target")
public class ProjectileMechanic
extends Projectile
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    @MythicField(name="type", description="The type of the projectile, NORMAL or METEOR", defValue="NORMAL")
    protected ProjectileType type;
    @MythicField(name="gravity", aliases={"g"}, description="The gravity modifier the projectile uses", defValue="0")
    protected PlaceholderFloat projectileGravity;
    @MythicField(name="bounces", aliases={"bounce"}, description="The projectile can bounce", defValue="false", premium=true)
    protected boolean bounce;
    @MythicField(name="bounceVelocity", aliases={"bv"}, description="The velocity modifier of the bounce", defValue="0.9")
    protected float bounceVelocityMod;
    @MythicField(name="highaccuracymode", aliases={"ham"}, description="Whether to use high-accuracy mode, which raytraces every tick to ensure the projectile cannot ever go anything", defValue="PLAYERS_ONLY")
    protected Projectile.ProjectileTriOption highAccuracyMode;
    @MythicFields(value={@MythicField(name="hugSurface", aliases={"hs"}, description="Whether the projectile will hug the surface", defValue="false"), @MythicField(name="hugLiquid", aliases={"hugWater", "hugLava"}, description="If hugSurface is set, determines whether the projectile will hug liquid", defValue="false")})
    protected ProjectileSurfaceMode surfaceMode = ProjectileSurfaceMode.NONE;
    @MythicField(name="heightFromSurface", aliases={"hfs"}, description="    The offset depends on the type of the projectile and if hugSurface is set.\n    NORMAL - how high above the surface the projectile will glide.\n    METEOR - how high above the surface the projectile starts above the target\n", defValue="0.5")
    protected float heightFromSurface;
    @MythicField(name="maxClimbHeight", aliases={"mch"}, description="The number of attempts the projectile will try to increase its y-location before terminating the projectile", defValue="3")
    protected float maxClimbHeight;
    @MythicField(name="maxDropHeight", aliases={"mdh"}, description="The number of attempts the projectile will try to decrease its y-location before terminating the projectile", defValue="10")
    protected float maxDropHeight;

    public ProjectileMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        String type = mlc.getString("type", "NORMAL");
        this.type = ProjectileType.valueOf(type.toUpperCase());
        this.projectileGravity = mlc.getPlaceholderFloat(new String[]{"gravity", "g"}, null, new String[0]);
        this.bounce = mlc.getBoolean(new String[]{"bounces", "bounce"}, false);
        this.bounceVelocityMod = mlc.getFloat(new String[]{"bouncevelocity", "bv"}, 0.9f);
        boolean hugSurface = mlc.getBoolean(new String[]{"hugsurface", "hs"}, false);
        this.heightFromSurface = mlc.getFloat(new String[]{"heightfromsurface", "hfs"}, 0.5f);
        this.maxClimbHeight = mlc.getFloat(new String[]{"maxclimbheight", "mch"}, 3.0f);
        this.maxDropHeight = mlc.getFloat(new String[]{"maxdropheight", "mdh"}, 10.0f);
        String highAccuracyDefault = "PLAYERS_ONLY";
        if (hugSurface) {
            highAccuracyDefault = "FALSE";
            boolean hugWater = mlc.getBoolean(new String[]{"hugliquid", "hugwater", "huglava"}, false);
            this.surfaceMode = hugWater ? ProjectileSurfaceMode.WATER : ProjectileSurfaceMode.SURFACE;
        }
        String highAccuracyMode = mlc.getString(new String[]{"highaccuracymode", "ham"}, highAccuracyDefault, new String[0]);
        try {
            this.highAccuracyMode = Projectile.ProjectileTriOption.valueOf(highAccuracyMode.toUpperCase());
        }
        catch (Throwable ex) {
            MythicLogger.errorMechanic(this, "Invalid input for highAccuracyMode option '" + highAccuracyMode + "'");
            this.highAccuracyMode = Projectile.ProjectileTriOption.PLAYERS_ONLY;
        }
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        try {
            new ProjectileMechanicTracker(data, target.clone().add(0.0, this.targetYOffset.get(data), 0.0));
            return SkillResult.SUCCESS;
        }
        catch (Exception ex) {
            MythicLogger.error("An error occurred executing a Projectile Mechanic", ex);
            return SkillResult.ERROR;
        }
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation().add(0.0, target.getEyeHeight() / 2.0, 0.0));
    }

    public ProjectileSurfaceMode getSurfaceMode() {
        return this.surfaceMode;
    }

    protected static enum ProjectileType {
        NORMAL,
        METEOR;

    }

    public class ProjectileMechanicTracker
    extends Projectile.ProjectileTracker {
        private float gravity;
        private float bounciness;
        private AbstractLocation target;

        public ProjectileMechanicTracker(SkillMetadata data, AbstractLocation target) {
            super(data, target);
            this.gravity = 0.0f;
            this.bounciness = 0.0f;
            this.target = target;
            if (ProjectileMechanic.this.bounce) {
                this.bounciness = ProjectileMechanic.this.projectileVelocity.get(data);
            }
            this.start();
        }

        @Override
        public void projectileStart() {
            if (ProjectileMechanic.this.type == ProjectileType.METEOR) {
                this.startLocation = this.target.clone();
                this.startLocation.add(0.0, ProjectileMechanic.this.heightFromSurface, 0.0);
                this.gravity = ProjectileMechanic.this.projectileGravity != null ? ProjectileMechanic.this.projectileGravity.get(this.data) : ProjectileMechanic.this.projectileVelocity.get(this.data);
                this.gravity /= ProjectileMechanic.this.ticksPerSecond;
                this.velocityMagnitude = 0.0;
            } else {
                double eso;
                double sso;
                double sfo;
                double syo;
                this.startLocation = ProjectileMechanic.this.sourceIsOrigin ? this.data.getOrigin().clone() : this.data.getCaster().getEntity().getLocation().clone();
                this.velocityMagnitude = ProjectileMechanic.this.projectileVelocity.get(this.data) / ProjectileMechanic.this.ticksPerSecond;
                this.gravity = ProjectileMechanic.this.projectileGravity != null ? ProjectileMechanic.this.projectileGravity.get(this.data) / ProjectileMechanic.this.ticksPerSecond : 0.0f;
                if (ProjectileMechanic.this.powerAffectsVelocity) {
                    this.velocityMagnitude *= (double)this.power;
                }
                if (ProjectileMechanic.this.tickInterpolation > 0) {
                    this.velocityMagnitude /= (double)(ProjectileMechanic.this.tickInterpolation + 1);
                    this.gravity /= (float)(ProjectileMechanic.this.tickInterpolation + 1);
                }
                if ((syo = ProjectileMechanic.this.startYOffset.get(this.data)) != 0.0) {
                    this.startLocation.setY(this.startLocation.getY() + syo);
                }
                if ((sfo = (double)(ProjectileMechanic.this.startForwardOffset.get(this.data) * -1.0f)) != 0.0) {
                    this.startLocation = MythicUtil.move(ProjectileMechanic.this.faulty, this.startLocation, sfo, 0.0, 0.0);
                }
                if ((sso = ProjectileMechanic.this.startSideOffset.get(this.data)) != 0.0) {
                    this.startLocation = MythicUtil.move(ProjectileMechanic.this.faulty, this.startLocation, 0.0, 0.0, sso);
                }
                if ((eso = ProjectileMechanic.this.endSideOffset.get(this.data)) != 0.0) {
                    this.target.setDirection(this.startLocation.getDirection());
                    this.target = MythicUtil.move(ProjectileMechanic.this.faulty, this.target, 0.0, 0.0, eso);
                }
            }
            this.previousLocation = this.startLocation.clone();
            this.currentLocation = this.startLocation.clone();
            if (this.currentLocation == null) {
                return;
            }
            this.currentVelocity = this.target.toVector().subtract(this.currentLocation.toVector()).normalize();
            if (ProjectileMechanic.this.projectileVelocityHorizOffset != null || ProjectileMechanic.this.projectileVelocityHorizNoise > 0.0f) {
                float noise = 0.0f;
                if (ProjectileMechanic.this.projectileVelocityHorizNoise > 0.0f) {
                    noise = (float)((double)ProjectileMechanic.this.projectileVelocityHorizNoiseBase + Numbers.randomDouble() * (double)ProjectileMechanic.this.projectileVelocityHorizNoise);
                }
                if (ProjectileMechanic.this.projectileVelocityHorizOffset != null) {
                    noise = (float)((double)noise + ProjectileMechanic.this.projectileVelocityHorizOffset.get(this.data).getDegrees());
                }
                this.currentVelocity.rotate(noise);
            }
            if (ProjectileMechanic.this.projectileVelocityVertOffset != null || ProjectileMechanic.this.projectileVelocityVertNoise > 0.0f) {
                float noise = 0.0f;
                if (ProjectileMechanic.this.projectileVelocityVertNoise > 0.0f) {
                    noise = (float)((double)ProjectileMechanic.this.projectileVelocityVertNoiseBase + Numbers.randomDouble() * (double)ProjectileMechanic.this.projectileVelocityVertNoise);
                }
                if (ProjectileMechanic.this.projectileVelocityVertOffset != null) {
                    noise = (float)((double)noise + ProjectileMechanic.this.projectileVelocityVertOffset.get(this.data).getSlope());
                }
                this.currentVelocity.add(new AbstractVector(0.0f, noise, 0.0f)).normalize();
            }
            if (ProjectileMechanic.this.surfaceMode != ProjectileSurfaceMode.NONE) {
                this.currentLocation.setY((float)((int)this.currentLocation.getY()) + ProjectileMechanic.this.heightFromSurface);
                this.currentVelocity.setY(0).normalize();
            }
            if (ProjectileMechanic.this.powerAffectsVelocity) {
                this.currentVelocity.multiply(this.power);
            }
            this.currentVelocity.multiply(this.velocityMagnitude);
            if (this.gravity != 0.0f) {
                this.currentVelocity.setY(this.currentVelocity.getY() - (double)this.gravity);
            }
            if (ProjectileMechanic.this.bullet != null) {
                this.bullet = ProjectileMechanic.this.bullet.create(this, null);
            }
        }

        public void setVelocity(float value) {
            this.velocityMagnitude = value / ProjectileMechanic.this.ticksPerSecond;
            if (ProjectileMechanic.this.tickInterpolation > 0) {
                this.velocityMagnitude /= (double)(ProjectileMechanic.this.tickInterpolation + 1);
            }
            this.currentVelocity = this.currentVelocity.normalize().multiply(this.velocityMagnitude);
        }

        public void multiplyVelocity(float v) {
            this.velocityMagnitude *= (double)v;
            this.currentVelocity = this.currentVelocity.multiply(v);
        }

        public void addVelocity(float v) {
            if (ProjectileMechanic.this.tickInterpolation > 0) {
                v /= (float)(ProjectileMechanic.this.tickInterpolation + 1);
            }
            this.velocityMagnitude = (this.velocityMagnitude * (double)ProjectileMechanic.this.ticksPerSecond + (double)v) / (double)ProjectileMechanic.this.ticksPerSecond;
            if (this.currentVelocity.length() != 0.0) {
                AbstractVector normalizedVelocity = this.currentVelocity.clone().normalize();
                AbstractVector flatAmountVector = normalizedVelocity.multiply(v);
                this.currentVelocity.add(flatAmountVector);
            }
        }

        public void setGravity(float p) {
            if (ProjectileMechanic.this.tickInterpolation > 0) {
                p /= (float)(ProjectileMechanic.this.tickInterpolation + 1);
            }
            this.gravity = p;
        }

        public void multiplyGravity(float p) {
            this.gravity *= p;
        }

        public void addGravity(float g2) {
            if (ProjectileMechanic.this.tickInterpolation > 0) {
                g2 /= (float)(ProjectileMechanic.this.tickInterpolation + 1);
            }
            this.gravity += g2;
        }

        private boolean isHighAccuracy() {
            return ProjectileMechanic.this.highAccuracyMode == Projectile.ProjectileTriOption.TRUE || ProjectileMechanic.this.highAccuracyMode == Projectile.ProjectileTriOption.PLAYERS_ONLY && this.data.getCaster().getEntity().isPlayer();
        }

        @Override
        public void projectileMove() {
            RayTraceResult traceResult;
            this.previousLocation = this.currentLocation.clone();
            this.currentLocation.add(this.currentVelocity);
            if (this.isHighAccuracy() && (traceResult = ((MythicBukkit)ProjectileMechanic.this.getPlugin()).getVolatileCodeHandler().getWorldHandler().rayTraceBlock(this.previousLocation, this.currentLocation, FluidCollisionMode.NEVER, true)) != null && traceResult.getHitBlock() != null && !traceResult.getHitBlock().isEmpty()) {
                AbstractLocation hitLocation = BukkitAdapter.adapt(traceResult.getHitPosition()).toLocation(this.currentLocation.getWorld());
                Location from = BukkitAdapter.adapt(this.previousLocation);
                Location to = BukkitAdapter.adapt(hitLocation);
                if (this.previousLocation.distanceSquared(hitLocation) <= this.previousLocation.distanceSquared(this.currentLocation)) {
                    if (ProjectileMechanic.this.stopOnHitGround) {
                        this.currentLocation = hitLocation;
                    } else if (ProjectileMechanic.this.onHitBlockSkill.isPresent() && ((Skill)ProjectileMechanic.this.onHitBlockSkill.get()).isUsable(this.data)) {
                        SkillMetadata sData = this.data.deepClone();
                        AbstractLocation location = ProjectileMechanic.this.bulletType.isPresent() && ProjectileMechanic.this.bulletType.get() == ProjectileBulletType.ARROW ? this.previousLocation.clone() : this.currentLocation.clone();
                        ((Skill)ProjectileMechanic.this.onHitBlockSkill.get()).execute(sData.setOrigin(location).setLocationTarget(location));
                    }
                }
            }
            if (ProjectileMechanic.this.surfaceMode != ProjectileSurfaceMode.NONE) {
                if (this.currentLocation.getBlockX() != this.previousLocation.getBlockX() || this.currentLocation.getBlockZ() != this.previousLocation.getBlockZ()) {
                    Block b = BukkitAdapter.adapt(this.currentLocation).subtract(0.0, (double)ProjectileMechanic.this.heightFromSurface, 0.0).getBlock();
                    if (BlockUtil.isPathable(b, ProjectileMechanic.this.surfaceMode)) {
                        boolean ok;
                        block22: {
                            attempts = 0;
                            ok = false;
                            while (true) {
                                int n = attempts++;
                                if (!((float)n < ProjectileMechanic.this.maxDropHeight)) break block22;
                                if (!BlockUtil.isPathable(b = b.getRelative(BlockFace.DOWN), ProjectileMechanic.this.surfaceMode)) break;
                                this.currentLocation.subtract(0.0, 1.0, 0.0);
                            }
                            ok = true;
                        }
                        if (!ok) {
                            this.terminate();
                            return;
                        }
                    } else {
                        boolean ok;
                        block23: {
                            attempts = 0;
                            ok = false;
                            do {
                                int n = attempts++;
                                if (!((float)n < ProjectileMechanic.this.maxClimbHeight)) break block23;
                                b = b.getRelative(BlockFace.UP);
                                this.currentLocation.add(0.0, 1.0, 0.0);
                            } while (!BlockUtil.isPathable(b));
                            ok = true;
                        }
                        if (!ok) {
                            this.terminate();
                            return;
                        }
                    }
                    this.currentLocation.setY((float)((int)this.currentLocation.getY()) + ProjectileMechanic.this.heightFromSurface);
                }
            } else if (this.gravity != 0.0f) {
                this.currentVelocity.setY(this.currentVelocity.getY() - (double)this.gravity);
            }
            if (ProjectileMechanic.this.bounce && MythicBukkit.isVolatile()) {
                try {
                    if (this.handleBounce()) {
                        this.executeProjectileSkill(ProjectileMechanic.this.onBounceSkill, this.data, false);
                    }
                }
                catch (IllegalArgumentException ex) {
                    MythicLogger.errorMechanicConfig(ProjectileMechanic.this, ProjectileMechanic.this.config, "An error occurred while calculating projectile bounce (did you set the bounding box to zero?)");
                    ex.printStackTrace();
                }
            } else if (ProjectileMechanic.this.stopOnHitGround && !BlockUtil.isPathable(BukkitAdapter.adapt(this.currentLocation).getBlock(), this)) {
                if (ProjectileMechanic.this.onHitBlockSkill.isPresent() && ((Skill)ProjectileMechanic.this.onHitBlockSkill.get()).isUsable(this.data)) {
                    SkillMetadata sData = this.data.deepClone();
                    AbstractLocation location = ProjectileMechanic.this.bulletType.isPresent() && ProjectileMechanic.this.bulletType.get() == ProjectileBulletType.ARROW ? this.previousLocation.clone() : this.currentLocation.clone();
                    ((Skill)ProjectileMechanic.this.onHitBlockSkill.get()).execute(sData.setOrigin(location).setLocationTarget(location));
                }
                this.currentLocation = this.previousLocation;
                this.terminate();
            }
        }

        @Override
        public void projectileTick() {
            if (ProjectileMechanic.this.onTickSkill.isPresent() && ((Skill)ProjectileMechanic.this.onTickSkill.get()).isUsable(this.data)) {
                SkillMetadata sData = this.data.deepClone();
                AbstractLocation location = ProjectileMechanic.this.bulletType.isPresent() && ProjectileMechanic.this.bulletType.get() == ProjectileBulletType.ARROW ? this.previousLocation.clone() : this.currentLocation.clone();
                ArrayList<AbstractLocation> targets = new ArrayList<AbstractLocation>();
                targets.add(location);
                sData.setLocationTargets(targets);
                sData.setOrigin(location);
                ((Skill)ProjectileMechanic.this.onTickSkill.get()).execute(sData);
            }
            this.evaluateTargetsInBB();
            if (!this.targets.isEmpty()) {
                this.doHit((Collection<AbstractEntity>)this.targets.clone());
                for (AbstractEntity target : this.targets) {
                    if (!ProjectileMechanic.this.canStopAtEntity(this.data, target)) continue;
                    this.terminate();
                    break;
                }
            }
            this.targets.clear();
        }

        private void doHit(Collection<AbstractEntity> targets) {
            this.hasHitEntity = true;
            if (ProjectileMechanic.this.onHitSkill.isPresent()) {
                SkillMetadata sData = this.data.deepClone();
                sData.setEntityTargets(targets);
                sData.setOrigin(this.currentLocation.clone());
                if (((Skill)ProjectileMechanic.this.onHitSkill.get()).isUsable(sData)) {
                    ((Skill)ProjectileMechanic.this.onHitSkill.get()).execute(sData);
                }
            }
        }

        @Override
        public void setCancelled() {
            this.terminate();
        }

        @Override
        public boolean getCancelled() {
            return this.components.hasTerminated();
        }

        public boolean handleBounce() {
            BoundingBox bb = BoundingBox.of((Location)BukkitAdapter.adapt(this.currentLocation), (double)ProjectileMechanic.this.hitRadius.get(this.data), (double)ProjectileMechanic.this.verticalHitRadius.get(this.data), (double)ProjectileMechanic.this.hitRadius.get(this.data));
            BlockFace collided = null;
            double bV = 0.0;
            for (PhysicsCollision collision : CollisionHelper.getCollisions(this.currentVelocity, bb, this.previousLocation)) {
                switch (collision.getBlockFace()) {
                    case NORTH: {
                        double magnitude = Math.abs(this.currentVelocity.getZ());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.NORTH;
                        break;
                    }
                    case EAST: {
                        double magnitude = Math.abs(this.currentVelocity.getZ());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.EAST;
                        break;
                    }
                    case SOUTH: {
                        double magnitude = Math.abs(this.currentVelocity.getZ());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.SOUTH;
                        break;
                    }
                    case WEST: {
                        double magnitude = Math.abs(this.currentVelocity.getZ());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.WEST;
                        break;
                    }
                    case UP: {
                        double magnitude = Math.abs(this.currentVelocity.getY());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.UP;
                        break;
                    }
                    case DOWN: {
                        double magnitude = Math.abs(this.currentVelocity.getY());
                        if (!(magnitude > bV)) break;
                        bV = magnitude;
                        collided = BlockFace.DOWN;
                        break;
                    }
                }
            }
            if (collided == null) {
                return false;
            }
            switch (collided) {
                case NORTH: {
                    if (!(this.currentVelocity.getZ() > 0.0)) break;
                    this.currentVelocity.setZ(this.currentVelocity.getZ() * -0.995);
                    break;
                }
                case EAST: {
                    if (!(this.currentVelocity.getX() < 0.0)) break;
                    this.currentVelocity.setX(this.currentVelocity.getX() * -0.995);
                    break;
                }
                case SOUTH: {
                    if (!(this.currentVelocity.getZ() < 0.0)) break;
                    this.currentVelocity.setZ(this.currentVelocity.getZ() * -0.995);
                    break;
                }
                case WEST: {
                    if (!(this.currentVelocity.getX() > 0.0)) break;
                    this.currentVelocity.setX(this.currentVelocity.getX() * -0.995);
                    break;
                }
                case UP: {
                    if (!(this.currentVelocity.getY() < 0.0)) break;
                    if (this.currentVelocity.getY() <= (double)(this.gravity * -1.0f)) {
                        this.currentVelocity.setY(this.currentVelocity.getY() * -0.8);
                        break;
                    }
                    this.currentVelocity.setY(0);
                    return false;
                }
                case DOWN: {
                    if (!(this.currentVelocity.getY() > 0.0)) break;
                    this.currentVelocity.setY(this.currentVelocity.getY() * -0.95);
                }
            }
            this.currentVelocity.multiply(ProjectileMechanic.this.bounceVelocityMod);
            return true;
        }
    }
}

