/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.bukkit.Location;
import org.bukkit.util.BoundingBox;

@MythicMechanic(author="Seyarada", name="polygon", aliases={}, description="Creates a polygon")
public class PolygonMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    @MythicField(name="points", aliases={"p"}, description="Amount of points in the lines", defValue="10")
    final PlaceholderInt points;
    @MythicField(name="distanceBetween", aliases={"distanceBetween", "distance", "density", "db"}, description="Number of iterations", defValue="0.1")
    final PlaceholderDouble distanceBetween;
    @MythicField(name="scale", aliases={"size", "s"}, description="Number of iterations", defValue="1")
    final PlaceholderDouble scale;
    @MythicField(name="skip", aliases={"star", "sv"}, description="Number of iterations", defValue="2")
    final PlaceholderInt skipVertices;
    @MythicField(name="duration", aliases={"d"}, description="Number of iterations", defValue="0")
    final PlaceholderInt duration;
    @MythicField(name="xOffset", aliases={"xo", "x"}, description="X-axis offset", defValue="0")
    final PlaceholderDouble xOffset;
    @MythicField(name="yOffset", aliases={"yo", "y"}, description="Y-axis offset", defValue="0")
    final PlaceholderDouble yOffset;
    @MythicField(name="zOffset", aliases={"zo", "z"}, description="Z-axis offset", defValue="0")
    final PlaceholderDouble zOffset;
    @MythicField(name="forwardOffset", aliases={"foffset", "fo"}, description="Forward offset", defValue="0")
    final PlaceholderDouble forwardOffset;
    @MythicField(name="pitch", description="The pitch rotation", defValue="0")
    final PlaceholderDouble pitch;
    @MythicField(name="yaw", description="The yaw rotation", defValue="0")
    final PlaceholderDouble yaw;
    @MythicField(name="roll", description="The roll rotation", defValue="0")
    final PlaceholderDouble roll;
    @MythicField(name="radius", description="The hit radius", defValue="1")
    final PlaceholderDouble radius;
    @MythicField(name="onPointSkill", aliases={"onpoint", "op"}, description="Skill triggered at each point", defValue="")
    final PlaceholderString pointSkillName;
    @MythicField(name="onEdgeSkill", aliases={"onedge", "oe"}, description="Skill triggered at the edges", defValue="")
    final PlaceholderString edgeSkillName;
    @MythicField(name="onStarSkill", aliases={"onstar", "os"}, description="Skill triggered at the star", defValue="")
    final PlaceholderString starSkillName;
    @MythicField(name="onHitEntitySkill", aliases={"onhitentity", "ohe", "oh"}, description="Skill triggered when it hits an entity", defValue="")
    final PlaceholderString hitEntitySkillName;
    @MythicField(name="rotation", aliases={"rot"}, description="The rotation of the cube, in the x,y,z format", defValue="0,0,0")
    final String rotationString;
    @MythicField(name="matchCasterDirection", aliases={"matchPlayerDirection", "matchDirection", "mcd", "mpd", "md", "direction"}, description="Match the caster's direction", defValue="false")
    final boolean matchCasterDirection;
    @MythicField(name="fromOrigin", description="Calculate the arc from the origin", defValue="false")
    final boolean fromOrigin;
    @MythicField(name="hitConditions", aliases={"conditions", "cond", "c", "oC", "hC"}, defValue="NONE", description="Conditions applied to the hit target")
    List<SkillCondition> hitConditions = null;
    @MythicField(name="directionTowardsTarget", description="If the yaw/pitch should be calculated to aim to the target", defValue="false")
    protected boolean directionTowardsTarget;
    @MythicField(name="targetxOffset", aliases={"xo", "x"}, description="Target X-axis offset", defValue="0")
    final PlaceholderDouble targetxOffset;
    @MythicField(name="targetyOffset", aliases={"yo", "y"}, description="Target Y-axis offset", defValue="0")
    final PlaceholderDouble targetyOffset;
    @MythicField(name="targetzOffset", aliases={"zo", "z"}, description="Target Z-axis offset", defValue="0")
    final PlaceholderDouble targetzOffset;
    final MythicLineConfig mlc;
    AbstractLocation location;
    AbstractVector rotation;
    String hitConditionString;
    Optional<Skill> onPointSkill;
    Optional<Skill> onEdgeSkill;
    Optional<Skill> onStarSkill;
    Optional<Skill> onHitEntitySkill;
    int parsedPoints;
    final HashSet<AbstractEntity> seenEntities = new HashSet();

    public PolygonMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.mlc = mlc;
        this.points = mlc.getPlaceholderInteger(new String[]{"points", "p"}, 32, new String[0]);
        this.distanceBetween = mlc.getPlaceholderDouble(new String[]{"distanceBetween", "distanceBetween", "distance", "density", "db", "d"}, 0.1, new String[0]);
        this.duration = mlc.getPlaceholderInteger(new String[]{"duration", "d"}, 0, new String[0]);
        this.scale = mlc.getPlaceholderDouble(new String[]{"scale", "size", "s"}, 1.0, new String[0]);
        this.skipVertices = mlc.getPlaceholderInteger(new String[]{"skip", "star", "sv"}, 2, new String[0]);
        this.radius = mlc.getPlaceholderDouble(new String[]{"radius", "r"}, 1.0, new String[0]);
        this.pitch = mlc.getPlaceholderDouble(new String[]{"pitch"}, 0.0, new String[0]);
        this.yaw = mlc.getPlaceholderDouble(new String[]{"yaw"}, 0.0, new String[0]);
        this.roll = mlc.getPlaceholderDouble(new String[]{"roll"}, 0.0, new String[0]);
        this.rotationString = mlc.getString(new String[]{"rotation", "rot"}, "0,0,0", new String[0]);
        this.matchCasterDirection = mlc.getBoolean(new String[]{"matchCasterDirection", "matchPlayerDirection", "matchDirection", "mcd", "mpd", "md", "direction"}, true);
        this.fromOrigin = mlc.getBoolean(new String[]{"fromOrigin"}, false);
        this.directionTowardsTarget = mlc.getBoolean(new String[]{"directionTowardsTarget", "dtt"}, false);
        this.pointSkillName = mlc.getPlaceholderString(new String[]{"onpointskill", "onpoint", "op"}, "", new String[0]);
        this.edgeSkillName = mlc.getPlaceholderString(new String[]{"onEdgeSkill", "onedge", "oe"}, "", new String[0]);
        this.starSkillName = mlc.getPlaceholderString(new String[]{"onStarSkill", "onstar", "os"}, "", new String[0]);
        this.hitEntitySkillName = mlc.getPlaceholderString(new String[]{"onHitEntitySkill", "onhitentity", "ohe", "oh"}, "", new String[0]);
        this.hitConditionString = mlc.getString(new String[]{"hitconditions", "conditions", "cond", "c", "oC", "hC"}, null, new String[0]);
        this.xOffset = mlc.getPlaceholderDouble(new String[]{"xoffset", "xo", "x"}, 0.0, new String[0]);
        this.yOffset = mlc.getPlaceholderDouble(new String[]{"yoffset", "yo", "y"}, 0.0, new String[0]);
        this.zOffset = mlc.getPlaceholderDouble(new String[]{"zoffset", "zo", "z"}, 0.0, new String[0]);
        this.targetxOffset = mlc.getPlaceholderDouble(new String[]{"targetxoffset", "txo", "tx"}, 0.0, new String[0]);
        this.targetyOffset = mlc.getPlaceholderDouble(new String[]{"targetyoffset", "tyo", "ty"}, 0.0, new String[0]);
        this.targetzOffset = mlc.getPlaceholderDouble(new String[]{"targetzoffset", "tzo", "tz"}, 0.0, new String[0]);
        this.forwardOffset = mlc.getPlaceholderDouble(new String[]{"forwardoffset", "foffset", "fo"}, 0.0, new String[0]);
        this.getManager().queueSecondPass(() -> {
            this.onPointSkill = this.getManager().getSkill(this.pointSkillName.get());
            if (this.onPointSkill.isEmpty() && !this.pointSkillName.get().equals("")) {
                MythicLogger.error("Could not find onPointSkill " + this.pointSkillName.get());
            }
            this.onEdgeSkill = this.getManager().getSkill(this.edgeSkillName.get());
            if (this.onEdgeSkill.isEmpty() && !this.edgeSkillName.get().equals("")) {
                MythicLogger.error("Could not find onEdgeSkill " + this.edgeSkillName.get());
            }
            this.onStarSkill = this.getManager().getSkill(this.starSkillName.get());
            if (this.onStarSkill.isEmpty() && !this.starSkillName.get().equals("")) {
                MythicLogger.error("Could not find onEdgeSkill " + this.starSkillName.get());
            }
            this.onHitEntitySkill = this.getManager().getSkill(this.hitEntitySkillName.get());
            if (this.onHitEntitySkill.isEmpty() && !this.hitEntitySkillName.get().equals("")) {
                MythicLogger.error("Could not find onHitEntitySkill " + this.hitEntitySkillName.get());
            }
            if (this.hitConditionString != null) {
                this.hitConditions = ((MythicBukkit)this.getPlugin()).getSkillManager().getConditions(this.hitConditionString);
            }
        });
    }

    public Triple<List<AbstractLocation>, List<AbstractLocation>, List<AbstractLocation>> getLocations(SkillMetadata data, AbstractLocation target) {
        AbstractVector casterRotation;
        AbstractLocation pos = this.fromOrigin ? data.getOrigin() : target;
        this.location = pos.clone();
        this.parsedPoints = this.points.get(data);
        this.rotation = this.parseRotation(this.rotationString, data);
        if (this.matchCasterDirection) {
            casterRotation = new AbstractVector(pos.getPitch(), pos.getYaw(), 0.0f);
        } else if (this.directionTowardsTarget) {
            AbstractLocation targetPos = target.add(this.targetxOffset.get(data), this.targetyOffset.get(data), this.targetzOffset.get(data));
            AbstractVector directionVector = targetPos.toVector().subtract(pos.toVector());
            double yaw = Math.atan2(directionVector.getZ(), directionVector.getX());
            yaw = Math.toDegrees(yaw) - 90.0;
            yaw = (yaw + 360.0) % 360.0;
            double horizontalDistance = Math.sqrt(directionVector.getX() * directionVector.getX() + directionVector.getZ() * directionVector.getZ());
            double pitch = Math.atan2(-directionVector.getY(), horizontalDistance);
            pitch = Math.toDegrees(pitch);
            casterRotation = new AbstractVector(pitch, yaw, 0.0);
        } else {
            casterRotation = new AbstractVector(0, 0, 0);
        }
        AbstractVector direction = pos.getDirection();
        return new MutableTriple(this.transformVectors(data, this.getEdgeTargets(this.points.get(data), this.scale.get(data)), casterRotation, direction), this.transformVectors(data, this.getLineTargets(this.points.get(data), this.distanceBetween.get(data), this.scale.get(data)), casterRotation, direction), this.transformVectors(data, this.getStarLineTargets(this.points.get(data), this.distanceBetween.get(data), this.scale.get(data), this.skipVertices.get(data)), casterRotation, direction));
    }

    List<AbstractLocation> transformVectors(SkillMetadata data, List<AbstractVector> vectors, AbstractVector casterRotation, AbstractVector direction) {
        return vectors.stream().map(vector -> this.rotateAroundAxisX((AbstractVector)vector, this.rotation.getX())).map(vector -> this.rotateAroundAxisY((AbstractVector)vector, this.rotation.getY())).map(vector -> this.rotateAroundAxisZ((AbstractVector)vector, this.rotation.getZ())).map(vector -> this.rotateAroundAxisX((AbstractVector)vector, casterRotation.getX())).map(vector -> this.rotateAroundAxisY((AbstractVector)vector, casterRotation.getY())).map(vector -> vector.add(direction.clone().normalize().multiply(this.forwardOffset.get(data)))).map(vector -> this.location.clone().add((AbstractVector)vector)).map(location1 -> location1.add(this.xOffset.get(data), this.yOffset.get(data), this.zOffset.get(data))).collect(Collectors.toList());
    }

    List<AbstractVector> getEdgeTargets(int points, double scale) {
        ArrayList<AbstractVector> targets = new ArrayList<AbstractVector>();
        for (int iteration = 0; iteration < points; ++iteration) {
            double angle = 360.0 / (double)points * (double)iteration;
            angle = Math.toRadians(angle);
            double x = Math.cos(angle) * scale;
            double z = Math.sin(angle) * scale;
            AbstractVector vector = new AbstractVector(x, 0.0, z);
            targets.add(vector);
        }
        return targets;
    }

    List<AbstractVector> getLineTargets(int points, double distanceBetween, double scale) {
        ArrayList<AbstractVector> targets = new ArrayList<AbstractVector>();
        for (int iteration = 0; iteration < points; ++iteration) {
            double angle = 360.0 / (double)points * (double)iteration;
            double nextAngle = 360.0 / (double)points * (double)(iteration + 1);
            angle = Math.toRadians(angle);
            nextAngle = Math.toRadians(nextAngle);
            double x = Math.cos(angle) * scale;
            double z = Math.sin(angle) * scale;
            double x2 = Math.cos(nextAngle) * scale;
            double z2 = Math.sin(nextAngle) * scale;
            double deltaX = x2 - x;
            double deltaZ = z2 - z;
            double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            int numSegments = (int)Math.floor(distance / distanceBetween);
            for (int i = 0; i < numSegments; ++i) {
                double t2 = (double)i / (double)numSegments;
                AbstractVector vector = new AbstractVector(x + deltaX * t2, 0.0, z + deltaZ * t2);
                targets.add(vector);
            }
        }
        return targets;
    }

    List<AbstractVector> getStarTargets(int points, double scale, int skipVertices) {
        ArrayList<AbstractVector> targets = new ArrayList<AbstractVector>();
        for (int iteration = 0; iteration < points; ++iteration) {
            double angle = 360.0 / (double)points * (double)(iteration * (skipVertices + 1));
            angle = Math.toRadians(angle);
            double x = Math.cos(angle) * scale;
            double z = Math.sin(angle) * scale;
            AbstractVector vector = new AbstractVector(x, 0.0, z);
            targets.add(vector);
        }
        return targets;
    }

    List<AbstractVector> getStarLineTargets(int points, double distanceBetween, double scale, int skipVertices) {
        List<AbstractVector> starVertices = this.getStarTargets(points, scale, skipVertices);
        ArrayList<AbstractVector> lineTargets = new ArrayList<AbstractVector>();
        for (int i = 0; i < points; ++i) {
            AbstractVector currentVertex = starVertices.get(i);
            AbstractVector nextVertex = starVertices.get((i + 1) % points);
            double deltaX = nextVertex.getX() - currentVertex.getX();
            double deltaZ = nextVertex.getZ() - currentVertex.getZ();
            double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            int numSegments = (int)Math.floor(distance / distanceBetween);
            for (int j = 0; j < numSegments; ++j) {
                double t2 = (double)j / (double)numSegments;
                AbstractVector vector = new AbstractVector(currentVertex.getX() + deltaX * t2, 0.0, currentVertex.getZ() + deltaZ * t2);
                lineTargets.add(vector);
            }
        }
        return lineTargets;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.castAtLocation(data, target.getLocation());
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Triple<List<AbstractLocation>, List<AbstractLocation>, List<AbstractLocation>> triple = this.getLocations(data, target);
        this.seenEntities.clear();
        this.handleLocations(data, (List)triple.getLeft(), 0);
        this.handleLocations(data, (List)triple.getMiddle(), 1);
        this.handleLocations(data, (List)triple.getRight(), 2);
        return SkillResult.SUCCESS;
    }

    void handleLocations(SkillMetadata data, List<AbstractLocation> locations, int type) {
        int finalDuration = this.duration.get(data);
        if (finalDuration > 0) {
            List<List<AbstractLocation>> partitions = PolygonMechanic.splitListEqually(locations, finalDuration);
            int delay = 0;
            AtomicInteger count = new AtomicInteger();
            for (List<AbstractLocation> partition : partitions) {
                Schedulers.async().runLater(() -> {
                    for (AbstractLocation abstractLocation : partition) {
                        this.executePoint(abstractLocation, data, type);
                        count.getAndIncrement();
                    }
                }, delay);
                ++delay;
            }
        } else {
            for (AbstractLocation abstractLocation : locations) {
                this.executePoint(abstractLocation, data, type);
            }
        }
    }

    void executePoint(AbstractLocation vector, SkillMetadata data, int type) {
        if (type == 0) {
            this.onEdgeSkill.ifPresent(skill -> skill.execute(data.setOrigin(vector).setLocationTarget(vector)));
        } else if (type == 1) {
            this.onPointSkill.ifPresent(skill -> skill.execute(data.setOrigin(vector).setLocationTarget(vector)));
        } else {
            this.onStarSkill.ifPresent(skill -> skill.execute(data.setOrigin(vector).setLocationTarget(vector)));
        }
        this.onHitEntitySkill.ifPresent(skill -> {
            if (skill.isUsable(data)) {
                Collection<AbstractEntity> entities = this.getEntitiesNearPoint(data, this.radius.get(data), vector);
                SkillMetadata meta = data.deepClone();
                meta.setEntityTargets(entities);
                meta.setOrigin(vector);
                skill.execute(meta);
            }
        });
    }

    AbstractVector parseRotation(String rotationString, SkillMetadata data) {
        double roll;
        double yaw;
        String[] split = rotationString.split(",");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (split.length == 3) {
            try {
                x = PlaceholderDouble.of(split[0]).get(data);
                y = PlaceholderDouble.of(split[1]).get(data);
                z = PlaceholderDouble.of(split[2]).get(data);
            }
            catch (NumberFormatException e) {
                MythicLogger.error("Invalid format for " + rotationString + " in " + this.mlc.getLine());
            }
        } else {
            MythicLogger.error("Invalid format for " + rotationString + " in " + this.mlc.getLine());
        }
        double pitch = this.pitch.get(data);
        if (pitch != 0.0) {
            x = pitch;
        }
        if ((yaw = this.yaw.get(data)) != 0.0) {
            y = yaw;
        }
        if ((roll = this.roll.get(data)) != 0.0) {
            z = roll;
        }
        return new AbstractVector(x, y, z);
    }

    AbstractVector rotateAroundAxisX(AbstractVector v, double angle) {
        angle = Math.toRadians(angle);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = v.getY() * cos - v.getZ() * sin;
        double z = v.getY() * sin + v.getZ() * cos;
        return v.setY(y).setZ(z);
    }

    AbstractVector rotateAroundAxisY(AbstractVector v, double angle) {
        angle = -angle;
        angle = Math.toRadians(angle);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos + v.getZ() * sin;
        double z = v.getX() * -sin + v.getZ() * cos;
        return v.setX(x).setZ(z);
    }

    AbstractVector rotateAroundAxisZ(AbstractVector v, double angle) {
        angle = Math.toRadians(angle);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos - v.getY() * sin;
        double y = v.getX() * sin + v.getY() * cos;
        return v.setX(x).setY(y);
    }

    Collection<AbstractEntity> getEntitiesNearPoint(SkillMetadata data, double radius, AbstractLocation vector) {
        ArrayList targets = Lists.newArrayList();
        for (AbstractEntity p : ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(vector, radius)) {
            if (this.seenEntities.contains(p) || p.getUniqueId().equals(data.getCaster().getEntity().getUniqueId()) || !this.getBoundingBox(vector, radius).overlaps(p.getBukkitEntity().getBoundingBox()) || !this.entityPassesConditions(data, p)) continue;
            this.seenEntities.add(p);
            targets.add(p);
        }
        return targets;
    }

    boolean entityPassesConditions(SkillMetadata data, AbstractEntity entity) {
        if (this.hitConditions != null) {
            for (SkillCondition condition : this.hitConditions) {
                if (condition.evaluateToEntity(data, entity)) continue;
                return false;
            }
        }
        return true;
    }

    public static <T> List<List<T>> splitListEqually(List<T> list, int numOfSublists) {
        int i;
        ArrayList<List<T>> sublists = new ArrayList<List<T>>(numOfSublists);
        for (i = 0; i < numOfSublists; ++i) {
            sublists.add(new ArrayList());
        }
        for (i = 0; i < list.size(); ++i) {
            int sublistIndex = i % numOfSublists;
            ((List)sublists.get(sublistIndex)).add(list.get(i));
        }
        return sublists;
    }

    public BoundingBox getBoundingBox(AbstractLocation location, double radius) {
        return BoundingBox.of((Location)BukkitAdapter.adapt(location), (double)radius, (double)radius, (double)radius);
    }
}

