/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.ITargetedLocationSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.ParticleEffect;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

@MythicMechanic(author="Ashijin", name="effect:particleEquation", aliases={"e:peq", "peq", "particleEquation"})
public class ParticleEquationEffect
extends ParticleEffect
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected final String equationStr;
    protected final double precision;
    protected final double tolerance;
    protected final double extentX;
    protected final double extentY;
    protected final double extentZ;
    protected final int maxSamples;
    protected final Map<String, Double> constVariables;
    protected final boolean relative;
    protected final double yawDeg;
    protected final double pitchDeg;

    public ParticleEquationEffect(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.ASYNC_ONLY;
        this.equationStr = mlc.getString("equation", "(x*x + y*y + z*z) - r*r");
        this.precision = Math.max(mlc.getDouble("precision", 0.25), 0.01);
        this.tolerance = Math.max(mlc.getDouble("tolerance", 0.1), 0.0);
        double radius = Math.max(mlc.getDouble("radius", 4.0), 0.01);
        double ex = mlc.getDouble("extentx", -1.0);
        double ey = mlc.getDouble("extenty", -1.0);
        double ez = mlc.getDouble("extentz", -1.0);
        this.extentX = ex > 0.0 ? ex : radius;
        this.extentY = ey > 0.0 ? ey : radius;
        this.extentZ = ez > 0.0 ? ez : radius;
        this.maxSamples = Math.max(mlc.getInteger("maxsamples", 250000), 1);
        this.constVariables = this.parseVariables(mlc.getString("variables", ""));
        this.relative = mlc.getBoolean("relative", false);
        this.yawDeg = mlc.getDouble("yaw", 0.0);
        this.pitchDeg = mlc.getDouble("pitch", 0.0);
    }

    private Map<String, Double> parseVariables(String variablesStr) {
        if (variablesStr == null || variablesStr.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Double> out = new LinkedHashMap<String, Double>();
        for (String part : variablesStr.split(";")) {
            String p = part.trim();
            if (p.isEmpty()) continue;
            String[] kv = p.split("=");
            if (kv.length != 2) {
                Log.warn("[peq] Ignoring variable '{}': expected key=value", p);
                continue;
            }
            String key = kv[0].trim();
            String val = kv[1].trim();
            if (key.isEmpty()) {
                Log.warn("[peq] Ignoring variable with empty name in '{}'", part);
                continue;
            }
            try {
                out.put(key, Double.parseDouble(val));
            }
            catch (NumberFormatException nfe) {
                Log.warn("[peq] Variable '{}' value '{}' is not a number; skipping.", key, val);
            }
        }
        return out;
    }

    @Override
    public SkillResult castAtLocation(SkillMetadata data, AbstractLocation target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, null);
        this.playParticleEquationEffect(data, target, audience);
        return SkillResult.SUCCESS;
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        Collection<AbstractPlayer> audience = this.audience.get(data, target);
        this.playParticleEquationEffect(data, target.getLocation(), audience);
        return SkillResult.SUCCESS;
    }

    protected void playParticleEquationEffect(SkillMetadata data, AbstractLocation center, Collection<AbstractPlayer> audience) {
        Expression expression;
        LinkedHashSet<String> varNames = new LinkedHashSet<String>();
        varNames.add("x");
        varNames.add("y");
        varNames.add("z");
        varNames.addAll(this.constVariables.keySet());
        try {
            expression = new ExpressionBuilder(this.equationStr).variables(varNames).build();
        }
        catch (Throwable t2) {
            Log.error("[peq] Failed to build expression '{}': {}", this.equationStr, t2.getMessage());
            return;
        }
        for (Map.Entry<String, Double> e : this.constVariables.entrySet()) {
            expression.setVariable(e.getKey(), e.getValue());
        }
        double effYawDeg = this.yawDeg;
        double effPitchDeg = this.pitchDeg;
        if (this.relative) {
            try {
                AbstractLocation loc = data.getCaster().getEntity().getLocation();
                effYawDeg += (double)loc.getYaw();
                effPitchDeg += (double)loc.getPitch();
            }
            catch (Throwable loc) {
                // empty catch block
            }
        }
        double yawRad = Math.toRadians(effYawDeg);
        double pitchRad = Math.toRadians(effPitchDeg);
        double minX = -this.extentX;
        double maxX = this.extentX;
        double minY = -this.extentY;
        double maxY = this.extentY;
        double minZ = -this.extentZ;
        double maxZ = this.extentZ;
        int nx0 = Math.max(1, (int)Math.floor((maxX - minX) / this.precision) + 1);
        int ny0 = Math.max(1, (int)Math.floor((maxY - minY) / this.precision) + 1);
        int nz0 = Math.max(1, (int)Math.floor((maxZ - minZ) / this.precision) + 1);
        long planned = 1L * (long)nx0 * (long)ny0 * (long)nz0;
        double step = this.precision;
        if (planned > (long)this.maxSamples) {
            double scale = Math.cbrt((double)planned / (double)this.maxSamples);
            step = this.precision * Math.max(1.0, scale);
        }
        this.renderGrid(data, center, audience, expression, minX, minY, minZ, step, yawRad, pitchRad);
    }

    private void renderGrid(SkillMetadata data, AbstractLocation center, Collection<AbstractPlayer> audience, Expression expression, double minX, double minY, double minZ, double step, double yawRad, double pitchRad) {
        double cx = center.getX();
        double cy = center.getY();
        double cz = center.getZ();
        AbstractLocation particleLocation = center.clone();
        int nx = Math.max(1, (int)Math.floor(this.extentX * 2.0 / step) + 1);
        int ny = Math.max(1, (int)Math.floor(this.extentY * 2.0 / step) + 1);
        int nz = Math.max(1, (int)Math.floor(this.extentZ * 2.0 / step) + 1);
        double cosY = Math.cos(yawRad);
        double sinY = Math.sin(yawRad);
        double cosP = Math.cos(pitchRad);
        double sinP = Math.sin(pitchRad);
        for (int ix = 0; ix < nx; ++ix) {
            double xLocal = minX + (double)ix * step;
            for (int iy = 0; iy < ny; ++iy) {
                double yLocal = minY + (double)iy * step;
                for (int iz = 0; iz < nz; ++iz) {
                    double result;
                    double zLocal = minZ + (double)iz * step;
                    double x1 = xLocal * cosY - zLocal * sinY;
                    double z1 = xLocal * sinY + zLocal * cosY;
                    double y1 = yLocal;
                    double y2 = y1 * cosP - z1 * sinP;
                    double z2 = y1 * sinP + z1 * cosP;
                    double x2 = x1;
                    expression.setVariable("x", x2);
                    expression.setVariable("y", y2);
                    expression.setVariable("z", z2);
                    try {
                        result = expression.evaluate();
                    }
                    catch (Throwable t2) {
                        continue;
                    }
                    if (!(Math.abs(result) <= this.tolerance)) continue;
                    particleLocation.setX(cx + x2);
                    particleLocation.setY(cy + y2);
                    particleLocation.setZ(cz + z2);
                    this.playParticleEffect(data, particleLocation, audience);
                }
            }
        }
    }
}

