/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IMetaSkill;
import io.lumine.mythic.api.skills.SkillHolder;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.mechanics.MetaSkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

@MythicMechanic(author="Lxlp", name="forEach", version="5.10", description="Runs a given metaskill for each element of the specified list")
public class ForEachMechanic
extends MetaSkillMechanic
implements IMetaSkill,
SkillHolder {
    final PlaceholderString targetType;
    private static final Map<String, TargetType> TARGETTYPE_TYPE_MAP = new HashMap<String, TargetType>();

    public ForEachMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.targetType = mlc.getPlaceholderString(new String[]{"targettype", "targett", "tt"}, "ALL", new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        if (this.metaskill.isEmpty()) {
            return SkillResult.INVALID_CONFIG;
        }
        TargetType targetType = TargetType.getOperator(this.targetType.get(data));
        switch (targetType.ordinal()) {
            case 0: {
                this.castEntity(data);
                break;
            }
            case 1: {
                this.castLocation(data);
                break;
            }
            case 2: {
                this.castEntity(data);
                this.castLocation(data);
            }
        }
        return SkillResult.SUCCESS;
    }

    private void castEntity(SkillMetadata data) {
        if (!data.hasEntityTargets()) {
            return;
        }
        data.getEntityTargets().forEach(entity -> {
            SkillMetadata newData = data.deepClone();
            newData.setEntityTarget((AbstractEntity)entity);
            super.cast(newData);
        });
    }

    private void castLocation(SkillMetadata data) {
        if (!data.hasLocationTargets()) {
            return;
        }
        data.getLocationTargets().forEach(location -> {
            SkillMetadata newData = data.deepClone();
            newData.setLocationTarget((AbstractLocation)location);
            super.cast(newData);
        });
    }

    private static enum TargetType {
        ENTITY("ENTITY"),
        LOCATION("LOCATION"),
        ALL("ALL");


        private TargetType(String ... aliases) {
            for (String alias : aliases) {
                TARGETTYPE_TYPE_MAP.put(alias, this);
            }
        }

        public static TargetType getOperator(String op) {
            return TARGETTYPE_TYPE_MAP.getOrDefault(op.toUpperCase(), ALL);
        }
    }
}

