/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractWorld;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.Skill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.serialize.Locus;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillTargeter;
import io.lumine.mythic.core.skills.auras.Aura;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="followPath", aliases={"path"}, description="Follow a path to a location")
public class FollowEntityMechanic
extends Aura
implements ITargetedEntitySkill {
    private List<PathTarget> points = Lists.newArrayList();
    private PlaceholderFloat speed;
    private double toleranceSquared;
    private PlaceholderDouble timeoutDistance;
    private PlaceholderInt timeoutTime;
    @MythicField(name="onGoal", aliases={"og", "then"}, version="4.14", description="Skill to execute when the destination is reached")
    protected Optional<Skill> onGoalSkill = Optional.empty();
    protected String onGoalSkillName;

    public FollowEntityMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.duration = mlc.getPlaceholderInteger(new String[]{"ticks", "t", "duration", "d", "time", "t"}, Integer.MAX_VALUE, new String[0]);
        this.auraName = Optional.of(PlaceholderString.of("#pathing"));
        this.charges = PlaceholderInt.of("1");
        this.maxStacks = PlaceholderInt.of("1");
        this.mergeAll = true;
        this.timeoutDistance = mlc.getPlaceholderDouble(new String[]{"timeoutdistance", "td", "maxdistance", "md"}, (PlaceholderDouble)null, new String[0]);
        this.timeoutTime = mlc.getPlaceholderInteger(new String[]{"timeouttime", "tt"}, (PlaceholderInt)null, new String[0]);
        String pathString = mlc.getString(new String[]{"path", "p"}, null, new String[0]);
        if (pathString == null) {
            MythicLogger.errorMechanicConfig(this, mlc, "Path is required");
            return;
        }
        this.speed = mlc.getPlaceholderFloat(new String[]{"speed", "s"}, 1.0f, new String[0]);
        this.toleranceSquared = Math.pow(mlc.getDouble(new String[]{"tolerance"}, 1.5), 2.0);
        this.onGoalSkillName = mlc.getString(new String[]{"ongoalskill", "ongoal", "og", "then"});
        List<String> pathPoints = this.splitPathString(pathString);
        for (String point : pathPoints) {
            if (point.startsWith("(")) {
                point = point.substring(1, point.length() - 1);
                this.points.add(new PathLocation(point));
                continue;
            }
            if (point.startsWith("@")) {
                this.points.add(new PathTargeter(point));
                continue;
            }
            MythicLogger.errorMechanicConfig(this, mlc, "Invalid path point format: " + point);
        }
        this.getManager().queueSecondPass(() -> {
            if (this.onGoalSkillName != null) {
                this.onGoalSkill = this.getManager().getSkill(file, this, this.onGoalSkillName);
            }
        });
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        new Tracker(data, target);
        return SkillResult.SUCCESS;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<String> splitPathString(String pathString) {
        ArrayList<String> result = new ArrayList<String>();
        int parenCount = 0;
        int curlyCount = 0;
        int squareCount = 0;
        StringBuilder segment = new StringBuilder();
        block9: for (char ch : pathString.toCharArray()) {
            switch (ch) {
                case '(': {
                    ++parenCount;
                    break;
                }
                case ')': {
                    --parenCount;
                    break;
                }
                case '{': {
                    ++curlyCount;
                    break;
                }
                case '}': {
                    --curlyCount;
                    break;
                }
                case '[': {
                    ++squareCount;
                    break;
                }
                case ']': {
                    --squareCount;
                    break;
                }
                case ',': {
                    if (parenCount != 0 || curlyCount != 0 || squareCount != 0) break;
                    result.add(segment.toString().trim());
                    segment = new StringBuilder();
                    continue block9;
                }
            }
            segment.append(ch);
        }
        if (segment.length() > 0) {
            result.add(segment.toString().trim());
        }
        return result;
    }

    protected class PathLocation
    implements PathTarget {
        private final Locus locus;

        public PathLocation(String location) {
            this.locus = Locus.deserialize(location);
        }

        @Override
        public AbstractLocation getLocation(SkillMetadata metadata, AbstractEntity entity) {
            AbstractWorld world = entity.getLocation().getWorld();
            double x = this.locus.getX();
            double y = this.locus.getY();
            double z = this.locus.getZ();
            return new AbstractLocation(world, x, y, z);
        }

        public Locus getLocus() {
            return this.locus;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathLocation)) {
                return false;
            }
            PathLocation other = (PathLocation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Locus this$locus = this.getLocus();
            Locus other$locus = other.getLocus();
            return !(this$locus == null ? other$locus != null : !((Object)this$locus).equals(other$locus));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PathLocation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Locus $locus = this.getLocus();
            result = result * 59 + ($locus == null ? 43 : ((Object)$locus).hashCode());
            return result;
        }

        public String toString() {
            return "FollowEntityMechanic.PathLocation(locus=" + String.valueOf(this.getLocus()) + ")";
        }
    }

    protected class PathTargeter
    implements PathTarget {
        private SkillTargeter targeter;

        public PathTargeter(String targeter) {
            this.targeter = ((MythicBukkit)FollowEntityMechanic.this.getPlugin()).getSkillManager().getTargeter(targeter);
        }

        @Override
        public AbstractLocation getLocation(SkillMetadata metadata, AbstractEntity entity) {
            if (this.targeter == null) {
                MythicLogger.errorMechanicConfig(FollowEntityMechanic.this, FollowEntityMechanic.this.getConfig(), "Invalid targeter supplied");
                return null;
            }
            return ((MythicBukkit)FollowEntityMechanic.this.getPlugin()).getSkillManager().getLocationTarget(this.targeter, metadata);
        }

        public SkillTargeter getTargeter() {
            return this.targeter;
        }

        public void setTargeter(SkillTargeter targeter) {
            this.targeter = targeter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathTargeter)) {
                return false;
            }
            PathTargeter other = (PathTargeter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SkillTargeter this$targeter = this.getTargeter();
            SkillTargeter other$targeter = other.getTargeter();
            return !(this$targeter == null ? other$targeter != null : !this$targeter.equals(other$targeter));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PathTargeter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SkillTargeter $targeter = this.getTargeter();
            result = result * 59 + ($targeter == null ? 43 : $targeter.hashCode());
            return result;
        }

        public String toString() {
            return "FollowEntityMechanic.PathTargeter(targeter=" + String.valueOf(this.getTargeter()) + ")";
        }
    }

    private class Tracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        private AbstractLocation currentTarget;
        private int currentPointIndex;
        private double timeoutDistance;
        private long timeoutTime;

        public Tracker(SkillMetadata data, AbstractEntity entity) {
            super(entity, data);
            this.currentPointIndex = 0;
            this.timeoutDistance = -1.0;
            this.timeoutTime = -1L;
            if (!FollowEntityMechanic.this.points.isEmpty()) {
                this.currentTarget = FollowEntityMechanic.this.points.get(0).getLocation(data, entity);
            }
            if (FollowEntityMechanic.this.timeoutDistance != null) {
                this.timeoutDistance = Math.pow(FollowEntityMechanic.this.timeoutDistance.get(data), 2.0);
            }
            if (FollowEntityMechanic.this.timeoutTime != null) {
                this.timeoutTime = System.currentTimeMillis() + (long)FollowEntityMechanic.this.timeoutTime.get(data);
            }
            this.start();
        }

        @Override
        public void auraStart() {
            this.executeAuraSkill(FollowEntityMechanic.this.onStartSkill, this.skillMetadata);
        }

        @Override
        public void auraTick() {
            if (this.currentTarget == null) {
                this.terminate();
                return;
            }
            AbstractLocation currentLocation = ((AbstractEntity)this.entity.get()).getLocation();
            double distanceSquared = currentLocation.distanceSquared(this.currentTarget);
            if (distanceSquared <= FollowEntityMechanic.this.toleranceSquared) {
                if (!this.next()) {
                    return;
                }
            } else if (this.timeoutDistance > 0.0 && distanceSquared > this.timeoutDistance) {
                ((AbstractEntity)this.entity.get()).teleport(this.currentTarget);
                if (!this.next()) {
                    return;
                }
            } else if (this.timeoutTime > 0L && System.currentTimeMillis() > this.timeoutTime) {
                ((AbstractEntity)this.entity.get()).teleport(this.currentTarget);
                if (!this.next()) {
                    return;
                }
            }
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Pathing to {0}", this.currentTarget.toString());
            ((MythicBukkit)FollowEntityMechanic.this.getPlugin()).getVolatileCodeHandler().getAIHandler().navigateToLocation((AbstractEntity)this.entity.get(), this.currentTarget, FollowEntityMechanic.this.speed.get(this.skillMetadata));
            SkillMetadata meta = this.skillMetadata.deepClone();
            meta.setOrigin(((AbstractEntity)this.entity.get()).getLocation());
            this.executeTargetedAuraSkill((Optional<Skill>)FollowEntityMechanic.this.onTickSkill, meta, this.currentTarget);
        }

        private boolean next() {
            ++this.currentPointIndex;
            if (this.currentPointIndex >= FollowEntityMechanic.this.points.size()) {
                if (FollowEntityMechanic.this.onGoalSkill.isPresent()) {
                    this.executeAuraSkill(FollowEntityMechanic.this.onGoalSkill, this.skillMetadata);
                }
                this.terminate();
                return false;
            }
            this.currentTarget = FollowEntityMechanic.this.points.get(this.currentPointIndex).getLocation(this.skillMetadata, (AbstractEntity)this.entity.get());
            if (FollowEntityMechanic.this.timeoutTime != null) {
                this.timeoutTime = System.currentTimeMillis() + (long)FollowEntityMechanic.this.timeoutTime.get(this.getSkillMetadata());
            }
            return true;
        }
    }

    protected static interface PathTarget {
        public AbstractLocation getLocation(SkillMetadata var1, AbstractEntity var2);
    }
}

