/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.compatibility.CompatibilityManager;
import io.lumine.mythic.core.skills.SkillAudience;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@MythicMechanic(author="Ashijin", name="disguiseAsBlock", description="Disguises the target entity")
public class DisguiseAsBlockMechanic
extends SkillMechanic
implements INoTargetSkill {
    @MythicField(name="audience", description="The target audience for the disguise.")
    protected SkillAudience audience;
    @MythicField(name="disguise", aliases={"type", "d"}, defValue="player Ashijin", description="The disguise to apply.")
    protected PlaceholderString disguise;

    public DisguiseAsBlockMechanic(SkillExecutor manager, File file, String skill, MythicLineConfig mlc) {
        super(manager, file, skill, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.audience = mlc.getAudience("audience", null);
        this.disguise = mlc.getPlaceholderString(new String[]{"type", "disguise", "d"}, "player Ashijin", new String[0]);
    }

    @Override
    public SkillResult cast(SkillMetadata data) {
        if (CompatibilityManager.LibsDisguises != null) {
            Disguise d = CompatibilityManager.LibsDisguises.getParsedDisguise(this.disguise.get(data));
            Entity entity = data.getCaster().getEntity().getBukkitEntity();
            if (this.audience == null) {
                DisguiseAPI.disguiseEntity((Entity)entity, (Disguise)d);
            } else {
                Collection<AbstractPlayer> audience = this.audience.get(data, data.getCaster().getEntity());
                ArrayList pa = Lists.newArrayList();
                for (AbstractEntity abstractEntity : audience) {
                    if (!abstractEntity.isPlayer()) continue;
                    pa.add((Player)abstractEntity.getBukkitEntity());
                }
                DisguiseAPI.disguiseToPlayers((Entity)entity, (Disguise)d, (Collection)pa);
            }
            return SkillResult.SUCCESS;
        }
        return SkillResult.MISSING_COMPATIBILITY;
    }
}

