/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.mechanics;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderBoolean;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.bukkit.adapters.BukkitAttribute;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillExecutor;
import io.lumine.mythic.core.skills.damage.DamagingMechanic;
import io.lumine.mythic.core.utils.annotations.MythicField;
import io.lumine.mythic.core.utils.annotations.MythicMechanic;
import java.io.File;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;

@MythicMechanic(author="Ashijin", name="physicalDamage", aliases={"meleeHit", "hit"}, description="")
public class DamagePhysicalMechanic
extends DamagingMechanic
implements ITargetedEntitySkill {
    @MythicField(name="multiplier", aliases={"m"}, description="The percentage of damage to deal", defValue="1")
    protected PlaceholderDouble multiplier;
    @MythicField(name="forcedDamage", aliases={"fd, forced"}, description="Forces the damage to be the amount specified, regardless of the damage of the entity")
    protected PlaceholderDouble forcedDamage;
    @MythicField(name="scaleByAttackCooldown", aliases={"fd, forced"}, description="Scales the damage by the weapon's attack cooldown")
    protected PlaceholderBoolean scaleByAttackCooldown;

    public DamagePhysicalMechanic(SkillExecutor manager, File file, String line, MythicLineConfig mlc) {
        super(manager, file, line, mlc);
        this.threadSafetyLevel = ThreadSafetyLevel.SYNC_ONLY;
        this.triggerSkills = mlc.getBoolean(new String[]{"triggerskills", "ts"}, true);
        this.multiplier = mlc.getPlaceholderDouble(new String[]{"multiplier", "m"}, 1.0, new String[0]);
        this.forcedDamage = mlc.getPlaceholderDouble(new String[]{"forcedDamage", "fd", "forced"}, 0.0, new String[0]);
        this.scaleByAttackCooldown = mlc.getPlaceholderBoolean(new String[]{"scaleByAttackCooldown", "sbac"}, (Boolean)false);
        this.cause = EntityDamageEvent.DamageCause.ENTITY_ATTACK;
        this.tags.add("melee");
    }

    @Override
    public SkillResult castAtEntity(SkillMetadata data, AbstractEntity target) {
        double damage;
        ActiveMob am;
        if (target.isDead() || target.getHealth() <= 0.0) {
            return SkillResult.INVALID_TARGET;
        }
        SkillCaster caster = data.getCaster();
        if (caster instanceof ActiveMob && (am = (ActiveMob)caster).isUsingDamageSkill()) {
            return SkillResult.INVALID_TARGET;
        }
        AbstractEntity entity = caster.getEntity();
        double multiplier = this.multiplier.get(data, target);
        if (this.forcedDamage.get(data, target) != 0.0) {
            damage = this.forcedDamage.get(data, target);
        } else {
            if (entity.isLiving()) {
                AttributeInstance attribute = ((LivingEntity)entity.getBukkitEntity()).getAttribute(BukkitAttribute.getAttribute("ATTACK_DAMAGE"));
                if (attribute != null) {
                    damage = attribute.getValue();
                } else if (caster instanceof ActiveMob) {
                    ActiveMob am2 = (ActiveMob)caster;
                    damage = am2.getDamage();
                } else {
                    damage = 1.0;
                }
            } else if (caster instanceof ActiveMob) {
                ActiveMob am3 = (ActiveMob)caster;
                damage = am3.getDamage();
            } else {
                damage = 1.0;
            }
            if (this.powerAffectsDamage) {
                damage *= (double)data.getPower();
            }
            if (this.scaleByAttackCooldown.get(data, target) && caster.getEntity().isPlayer()) {
                double cdMultiplier;
                if (data.getVariables().has("hit-attack-cooldown")) {
                    cdMultiplier = data.getVariables().getDouble("hit-attack-cooldown");
                } else {
                    cdMultiplier = ((Player)caster.getEntity().asPlayer().getBukkitEntity()).getAttackCooldown();
                    data.getVariables().putDouble("hit-attack-cooldown", cdMultiplier);
                }
                damage *= cdMultiplier;
            }
        }
        MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "+ DamageBaseMechanic fired for {0} with {1} power", damage, Float.valueOf(data.getPower()));
        this.doDamage(data, target, damage, multiplier);
        return SkillResult.SUCCESS;
    }
}

