/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.api.skills.conditions.ISkillMetaComparisonCondition;
import io.lumine.mythic.api.skills.conditions.ISkillMetaCondition;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.api.skills.placeholders.PolymorphicPlaceholder;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.PlaceholderContext;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.variables.Variable;
import io.lumine.mythic.core.skills.variables.VariableCondition;
import io.lumine.mythic.core.skills.variables.VariableRegistry;
import io.lumine.mythic.core.skills.variables.VariableType;
import io.lumine.mythic.core.skills.variables.interfaces.ContainingVariable;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@MythicCondition(author="Lxlp", name="variableContains", aliases={"variableContain", "varContains", "varContain", "varCont"}, version="5.10", description="Checks if the specified variable contains a given value. This can either be done between strings or sets")
public class VariableContainsCondition
extends VariableCondition
implements IEntityCondition,
ILocationCondition,
ISkillMetaCondition,
ISkillMetaComparisonCondition {
    @MythicField(name="value", aliases={"val", "v"}, description="The value to match")
    private PolymorphicPlaceholder value;
    private PlaceholderString compareType;
    private static final Map<String, CompareType> COMPARE_TYPE_MAP = new HashMap<String, CompareType>();

    public VariableContainsCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        try {
            this.value = PolymorphicPlaceholder.of(mlc.getString(new String[]{"value", "val", "v"}, null, new String[0]));
            this.value.cache(VariableType.STRING);
            this.compareType = PlaceholderString.of(mlc.getString(new String[]{"compareType", "compare", "comp"}, "ALL", new String[0]));
        }
        catch (Exception ex) {
            MythicLogger.errorConditionConfig(this, mlc, "Variable value must be set.");
            return;
        }
    }

    private void handleException(Exception ex) {
        MythicLogger.error("Failed to process VariableContains condition.");
        MythicLogger.handleMinorError(ex);
    }

    private boolean checkContainsPlain(String value, String target, @NotNull CompareType compareType) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "VariableContains: checking {0} \u2208 {1}", target, value);
        if (value.contains(",")) {
            HashSet<String> valueSet = new HashSet<String>(Arrays.asList(value.split(",")));
            if (target.contains(",")) {
                HashSet<String> targetSet = new HashSet<String>(Arrays.asList(target.split(",")));
                if (Objects.requireNonNull(compareType) == CompareType.ANY) {
                    for (String t2 : targetSet) {
                        if (!valueSet.contains(t2)) continue;
                        return true;
                    }
                    return false;
                }
                return valueSet.containsAll(targetSet);
            }
            return valueSet.contains(target);
        }
        return switch (compareType.ordinal()) {
            case 2 -> value.startsWith(target);
            case 3 -> value.endsWith(target);
            default -> value.contains(target);
        };
    }

    private boolean checkWithContext(VariableRegistry registry, CompareType compareType, PlaceholderContext context) {
        Variable var;
        if (compareType == CompareType.ALL && (var = registry.get(this.key.get(context))) instanceof ContainingVariable) {
            ContainingVariable containingVariable = (ContainingVariable)((Object)var);
            return containingVariable.checkContainsAll(this.value, context);
        }
        String value = this.value.getString(context);
        try {
            String variableValue = registry.getString(this.key.get(context));
            return this.checkContainsPlain(variableValue, value, compareType);
        }
        catch (Exception ex) {
            this.handleException(ex);
            return false;
        }
    }

    @Override
    public boolean check(AbstractEntity target) {
        VariableRegistry registry = VariableContainsCondition.getPlugin().getVariableManager().getRegistry(this.scope, target);
        CompareType compareType = CompareType.getOperator(this.compareType.get(target));
        return this.checkWithContext(registry, compareType, PlaceholderContext.ofEntity(target));
    }

    @Override
    public boolean check(AbstractLocation target) {
        VariableRegistry registry = VariableContainsCondition.getPlugin().getVariableManager().getRegistry(this.scope, target);
        CompareType compareType = CompareType.getOperator(this.compareType.get());
        return this.checkWithContext(registry, compareType, PlaceholderContext.ofLocation(target));
    }

    @Override
    public boolean check(SkillMetadata meta, AbstractEntity target) {
        VariableRegistry registry = VariableContainsCondition.getPlugin().getVariableManager().getRegistry(this.scope, meta, target);
        CompareType compareType = CompareType.getOperator(this.compareType.get((PlaceholderMeta)meta, target));
        return this.checkWithContext(registry, compareType, PlaceholderContext.of(meta, target, null, null, null));
    }

    @Override
    public boolean check(SkillMetadata meta) {
        VariableRegistry registry = VariableContainsCondition.getPlugin().getVariableManager().getRegistry(this.scope, meta, meta.getCaster().getEntity());
        CompareType compareType = CompareType.getOperator(this.compareType.get(meta));
        return this.checkWithContext(registry, compareType, PlaceholderContext.of(meta, meta.getCaster().getEntity(), null, null, null));
    }

    private static enum CompareType {
        ALL("ALL"),
        ANY("ANY"),
        STARTS_WITH("STARTS_WITH", "SW"),
        ENDS_WITH("ENDS_WITH", "EW");


        private CompareType(String ... aliases) {
            for (String alias : aliases) {
                COMPARE_TYPE_MAP.put(alias, this);
            }
        }

        public static CompareType getOperator(String op) {
            return COMPARE_TYPE_MAP.getOrDefault(op.toUpperCase(), ALL);
        }
    }
}

