/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.core.skills.conditions.all;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.conditions.ISkillMetaCondition;
import io.lumine.mythic.bukkit.utils.numbers.RangedInt;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.SkillCondition;
import io.lumine.mythic.core.utils.annotations.MythicCondition;
import io.lumine.mythic.core.utils.annotations.MythicField;

@MythicCondition(author="Ashijin", name="threatNotWithin", description="Checks if any players are within a radius of the target")
public class ThreatsNotWithinCondition
extends SkillCondition
implements ISkillMetaCondition {
    @MythicField(name="distance", aliases={"d"}, description="The radius to check in")
    private double distance;
    @MythicField(name="amount", aliases={"a"}, description="The amount to check")
    private RangedInt amount;

    public ThreatsNotWithinCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.distance = Math.pow(Double.valueOf(mlc.getString(new String[]{"distance", "d"}, this.conditionVar, new String[0])), 2.0);
        String a = mlc.getString(new String[]{"amount", "a"}, "0", this.conditionVar);
        this.amount = new RangedInt(a);
    }

    @Override
    public boolean check(SkillMetadata meta) {
        ActiveMob am;
        SkillCaster skillCaster = meta.getCaster();
        if (skillCaster instanceof ActiveMob && (am = (ActiveMob)skillCaster).hasThreatTable()) {
            int count = 0;
            for (AbstractEntity entity : am.getThreatTable().getAllThreatTargets()) {
                if (entity.isPlayer() && (entity.asPlayer().isInSpectatorMode() || entity.asPlayer().isInCreativeMode()) || !(entity.getLocation().distanceSquared(am.getLocation()) <= this.distance)) continue;
                ++count;
            }
            return !this.amount.equals(count);
        }
        return true;
    }
}

